<?php

namespace App\Http\Resources\ManagerDashboard\Circulars;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class InternalCircularResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        return [
            'id'=> $this->id,
            'type'=> 'internalCirculars',
            'school_id' => $this->school_id,
            'school_name' => $this->school->name,
            'serial_number'=> $this?->namozegVersion?->serial_number,
            'title' => $this->title,
            'details' => $this->details ,
            'date' => $this->date,
            'date_type' => $this->date_type,
            'date_options'=> Helper::getDateOptions($this->date, $this->date_type),
            'day' => $this->day,
            'teachers' => $this->teachers,
        ];
    }
}
