<?php

namespace App\Http\Resources\ManagerDashboard\AbsenseAndLateness;

use App\Helpers\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class StudentAttendanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=> $this->id,
            'school_id'=> $this->school_id,
            'semester_id'=> $this->semester_id,
            'name'=> $this->student?->name,
            'student_id'=>$this->student_id,
            'date'=>$this->date,
            'date_type'=>$this->date_type,
            'date_options'=> Helper::getDateOptions($this->date, $this->date_type),
            'status'=> $this->status,
            'absence_reason'=> $this->absence_reason,
        ];
    }
}
