<?php

namespace App\Http\Resources\AdminDashboard\NamazegCategory;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class NamazegCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return 
        [
            'id' => $this->id,
            'name' => $this->name,
            'subCategories' => $this->when($this->relationLoaded('subCategories') && $this->subCategories->isNotEmpty(), function () {
                return NamazegCategoryResource::collection($this->subCategories);
            }),
        ];
    }
}
