<?php

namespace App\Http\Resources\AdminDashboard\Logs;

use App\Helpers\Helper;
use App\Models\Namazeg;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class LogResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $form_number = isset($this->properties['form_number']) ? $this->properties['form_number'] : null;
        $namozeg = Namazeg::firstWhere('form_number', $form_number);
        $data = [
            'id' => $this->id,
            'user_name'  => optional($this->causer)->name,
            'role_name' => optional($this->causer)?->roles?->pluck('name_ar'),
            'form_number' => $namozeg? $namozeg->form_number:null,
            'description' => __('api.' . $this->event) . ' ' . __('api.' . $this->description) . ' ' . __('api.by') . ' ' . optional($this->causer)->name,
            'created_at' => Carbon::parse($this->created_at)->translatedFormat('l، j F، Y الساعة g:i A'),
        ];
        return $data;
    }
}
