<?php

namespace App\Http\Resources\AdminDashboard\Clients;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Settings\Subscription;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ClientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $subscription_diff =  $this->end_date ? ((Carbon::createFromFormat('d/m/Y', $this->end_date) > Carbon::now()) ? Carbon::createFromFormat('d/m/Y', $this->end_date)->diffInDays(Carbon::now()) : 0) : 0;
        ($subscription_diff <= 30 && $subscription_diff > 0) ? $end_soon = true : $end_soon = false;

        $schoolNames = School::where('user_id', $this->user_id)
            ->pluck('name')
            ->toArray();

        return
        [
            'subscription_id' => $this->id,
            'user_id' => $this->user_id,
            'client_name' => $this->user?->name,
            'client_type' => $this->status,
            'end_soon' => $end_soon,
            'schools' => $schoolNames,
            'last_seen' => $this->user?->getLastSeen(),
            'join_date' => $this->user?->created_at ? Helper::getDateOptions(Carbon::parse($this->user->created_at)->format('d/m/Y'), 'coptic') : null,
            'account_status' => $this->user?->status,
            'cancellation_request_status' => $this->cancellation_request_status,
        ];
    }
}
