<?php

namespace App\Http\Resources\AdminDashboard\BankAccount;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BankAccountResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'bank_name' =>  $this->bank_name,
            'account_name' => $this->account_name,
            'account_number' => $this->account_number,
            'IBAN' => $this->IBAN,
            'bank_logo' => $this->bank_logo ? url('public/uploads/BankAccounts/'.$this->bank_logo) : null,
            'status' => $this->status
        ];
    }
}
