<?php

namespace App\Http\Requests\Video;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VideoUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $videoId = $this->route('id'); // 'video' should match the route parameter name

        return [
            'name' => 'string',
            'video_link' => 'string',
            'category_id' => [
                'exists:categories,id', // Ensure the category exists
                Rule::unique('videos', 'category_id')->ignore($videoId), // Ignore the current video
            ],
        ];
    }
}
