<?php

namespace App\Http\Requests\Notification;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class NotificationUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return[
            'title' => 'string',
            'body' => 'string',
            'receptor' => 'string|in:all_cities,specific_cities,specific_receptors',
            'date_type' => 'string|in:coptic,hijri',
            'scheduled' => 'string|in:1,0',
        ];
        
    }

}
