<?php

namespace App\Http\Requests\ManagerDashboard\Violations;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ManagerVioaltionStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'student_id' => 'required|integer|exists:school_students,id',
            'violation_grade_id' => 'required|integer|exists:violation_grades,id',
            'violation_category_id' => 'required|integer|exists:violations,id',
            // 'violation_type_id' => 'required|integer|exists:violation_types,id',
            'date' => ['required', 'date_format:d/m/Y','string','before_or_equal:today', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|string|in:coptic,hijri'
        ];
    }

    public function messages()
    {
        return [
            'date.before_or_equal' => 'التاريخ يجب ان يكون مطابقا او مسبقا لليوم.',
        ];
    }

}
