<?php

namespace App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCommiteeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'school_id' => 'exists:schools,id',
            'name' => 'string|max:150',
            'form_number' => 'nullable|unique:committees,form_number|exists:namazeg,form_number',
            'assignment_form_number' => 'nullable|unique:committees,form_number|exists:namazeg,form_number',
            'status' =>['in:1,0'],
        ];
    }
}
