<?php

namespace App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class MeetingDetailsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'attendances_count' => 'required|integer',
            'target_audience' => 'required|string',
            'end_time' => 'required|string',
            'schedual_details' => 'required|array',
            'schedual_details.*.details' => 'required|string',
            'recommendations' => 'required|array',
            'recommendations.*.recommendation' => 'required|string',
            'recommendations.*.executive_authority' => 'required|string',
            'recommendations.*.execution_time' => 'required|string',
            'recommendations.*.belonged_executive_authority' => 'required|string',
            'recommendations.*.recommendation_status' => 'required|in:executed,not_executed',
            'recommendations.*.reason_of_not_execution' => 'nullable|string'
        ];
    }


}
