<?php

namespace App\Http\Requests\ManagerDashboard\Tables\ClassRoomVisits;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class UpdateClassVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'school_id' => ['exists:schools,id'],
            'data' => ['array'],
            'data.*.semester_id' => ['integer', 'exists:semesters,id'],
            'data.*.visites' => ['array'],
            'data.*.visites.*.visiting_teacher_id' => ['integer', 'exists:school_employees,id'],
            'data.*.visites.*.visited_teacher_id' => ['integer', 'exists:school_employees,id'],
            'data.*.visites.*.period_id' => ['integer', 'exists:periods,id'],
            'data.*.visites.*.subject_id' => ['integer', 'exists:subjects,id'],
            'data.*.visites.*.school_class_id' => ['integer', 'exists:school_classes,id'],
            'data.*.visites.*.date' => [
                'nullable',
                function ($attribute, $value, $fail) use ($request) {
                    // Extract the indices from the attribute path
                    $path = explode('.', $attribute);
                    $semesterIndex = $path[1]; // Index of the semester
                    $visitIndex = $path[3]; // Index of the visit

                    // Get the date_type for the current visit
                    $dateType = $request->input("data.{$semesterIndex}.visites.{$visitIndex}.date_type");

                    // Validate the date with the correct dateType
                    if ($dateType === null) {
                        $fail("The date_type for the visit is required.");
                        return;
                    }

                    $validator = new DateWithinSemester($dateType);
                    $validator->validate($attribute, $value, $fail);
                }
            ],
            'data.*.visites.*.date_type' => ['in:hijri,coptic'],
        ];
    }
}