<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class TransformQuroanStudentStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'student_name' => 'required|exists:school_students,id',
            'birth_date' => 'required|string',
            'birth_date_type' => 'required|in:hijri,coptic',
            'certificate_date' => 'required|string',
            'certificate_date_type' => 'required|in:hijri,coptic',
            'last_certificate' => 'required|string',
            'certificate_source' => 'required|string',
            'trans_form' => 'required|string',
            'trans_to' => 'required|string',
            'study_type' => 'required|in:eveninig,night,affilation',

            'n_faild_years'=> 'nullable|string',
            'faild_subjects'=> 'nullable|string',
            'n_stoped_years'=> 'nullable|string',
            'stoped_reasons'=> 'nullable|string',
            'form_department_number'=> 'nullable|string',
            'form_department_date' => ['nullable', 'string', new DateWithinSemester()],

            'degrees'=>'array',
        ];
        return $rules;
    }
}
