<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class StudentDataStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'type' => 'required|in:student,many_student,school_class,class,all_student',
        ];
        if ($request->type == "many_student") {
            $rules['type_value'] = 'required|array';
            $rules['type_value.*'] = 'required|exists:school_students,id';
        } elseif ($request->type == "student") {
            $rules['type_value'] = 'required|exists:school_students,id';
        } elseif ($request->type == "school_class") {
            $rules['type_value'] = 'required|exists:school_classes,id';
        }
        return $rules;
    }
}
