<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class NotifyLateLeavingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'employee_id' => 'required|exists:school_employees,id',
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],

            'date_type' => 'required|in:coptic,hijri',
            'level' => 'required|string',
            'type' => 'required|in:start,during,leaving',
        ];
        if ($request->type == "start") {
            $rules['start_date'] = 'required|string';
            // $rules['start_date_type'] = 'required|in:coptic,hijri';
        } elseif ($request->type == "leaving") {
            $rules['end_date'] = 'required|string';
            // $rules['end_date_type'] = 'required|in:coptic,hijri';
        } else {
            $rules['start_date'] = 'required|string';
            $rules['end_date'] = 'required|string';
        }
        return $rules;
    }
}
