<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class EvacuationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],

            'date_type' => 'required|in:coptic,hijri',
            'time' => 'required|string',
            'n_students' => 'required|string',
            'n_employees' => 'required|string',
            'duration' => 'required|string',
            'safety_man' => 'required|string',
            'images' => 'nullable|array',
            'images.*' => 'nullable|image'
        ];
        return $rules;
    }
}
