<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class CircularAttendanceReportStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'code' => 'required|string',
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|in:hijri,coptic',
            'issued_by' => 'required|string',
            'about' => 'required|string',
            'directed_to' => 'required|in:teachers,adminstrators,teachers_adminstrators',
        ];
        return $rules;
    }
}
