<?php

namespace App\Http\Requests\ManagerDashboard\LettersAndAlarts;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;

class UpdateLetterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'type' => ['in:official,warning'],
            'date_type' => ['in:hijri,coptic'],
            'date' => ['nullable'],
            'title' => ['string','max:255'],
            'letter_for' => ['string'],
            'details' => ['string']
        ];
    }




      public function messages(): array
      {
          return [
            'type.required' => 'نوع الخطاب مطلوب.',
            'type.in' => 'نوع الخطاب يجب أن يكون "رسمي" أو "تحذيري".',

            'date_type.required' => 'نوع التاريخ مطلوب.',
            'date_type.in' => 'نوع التاريخ يجب أن يكون "هجري" أو "قبطي".',

            'date.required' => 'تاريخ الخطاب مطلوب.',
            'date.date' => 'تاريخ الخطاب يجب أن يكون بتنسيق تاريخ صحيح.',

            'title.required' => 'عنوان الخطاب مطلوب.',
            'title.string' => 'عنوان الخطاب يجب أن يكون نصاً.',

            'letter_for.required' => 'المستلم مطلوب.',
            'letter_for.string' => 'المستلم يجب أن يكون نصاً.',

            'details.required' => 'تفاصيل الخطاب مطلوبة.',
            'details.string' => 'تفاصيل الخطاب يجب أن تكون نصاً.',
          ];
      }
}
