<?php

namespace App\Http\Requests\ManagerDashboard\LettersAndAlarts;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class StoreLetterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'type' => ['required','in:official,warning'],
            'date_type' => ['required','in:hijri,coptic'],
            'date' => ['required', 'date_format:d/m/Y',new DateWithinSemester($request->input('date_type'))],
            'title' => ['required','string','max:255'],
            'letter_for' => ['required','string'],
            'details' => ['required','string']
        ];
    }




      public function messages(): array
      {
          return [
             'type.required' => 'نوع الخطاب مطلوب.',
            'type.in' => 'نوع الخطاب يجب أن يكون "رسمي" أو "تحذيري".',

            'date_type.required' => 'نوع التاريخ مطلوب.',
            'date_type.in' => 'نوع التاريخ يجب أن يكون "هجري" أو "قبطي".',

            'date.required' => 'تاريخ الخطاب مطلوب.',
            'date.date' => 'تاريخ الخطاب يجب أن يكون بتنسيق تاريخ صحيح.',

            'title.required' => 'عنوان الخطاب مطلوب.',
            'title.string' => 'عنوان الخطاب يجب أن يكون نصاً.',

            'letter_for.required' => 'المستلم مطلوب.',
            'letter_for.string' => 'المستلم يجب أن يكون نصاً.',

            'details.required' => 'تفاصيل الخطاب مطلوبة.',
            'details.string' => 'تفاصيل الخطاب يجب أن تكون نصاً.',
          ];
      }
}
