<?php

namespace App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCorrectionAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'subject_id'  => [ 'exists:subjects,id'],
            'location' => ['string'],
            'round' => ['in:الأول,الثاني'],
            'members'=> ['array'],
            'members.*.employee_id' => ['exists:school_employees,id'], 
            'members.*.assignment_work' => ['string'],  
            'members.*.mission' => ['nullable', 'string'],
        ];
    }
}
