<?php

namespace App\Http\Requests\ManagerDashboard\Exams\StudentCommittes;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Rules\UniqueCommitteeLocation;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class StoreCommitteeDataRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $school = School::findOrFail($this->route('school')->id);
        $committee = StudentCommittee::findOrFail($this->route('committee')->id);


        return [
            'location' => [
                'required',
                'string',
                new UniqueCommitteeLocation($school,  $committee)
            ],
            'assignments' => ['required', 'array'],
            'assignments.*.column_number' => ['required', 'integer'],
            'assignments.*.student_ids' => ['required', 'array'],
            'assignments.*.student_ids.*' => [
                'required',
                'exists:school_students,id',

            ]
        ];
    }
}
