<?php

namespace App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration;

use Illuminate\Foundation\Http\FormRequest;

class StoreTeacherCurriculumDeclarationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $schoolId = $this->route('school')->id;

        return [
            'teacher_id' =>  [
                'required',
                'exists:school_employees,id',
                function ($attribute, $value, $fail) use ($schoolId) {
                    if (!\DB::table('school_employees')->where('id', $value)->where('school_id', $schoolId)->exists()) {
                        $fail("The selected employee ID {$value} must exist in the school_employees table for this school.");
                    }
                },
            ]
        ];
    }
}
