<?php

namespace App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgress;

use Illuminate\Foundation\Http\FormRequest;

class StoreAnswerSheetProgressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        $schoolId = $this->route('school')->id;

        return [
            "schoolClass_id" => [
                'required',
                'exists:school_classes,id',
                function ($attribute, $value, $fail) use ($schoolId) {
                    if (!\DB::table('school_classes')->where('id', $value)->where('school_id', $schoolId)->exists()) {
                        $fail("The selected school classes ID {$value} must exist in the school_classes table for this school.");
                    }
                },
            ]
        ];
    }
}
