<?php

namespace App\Http\Requests\ManagerDashboard\ClassRoomVisit;

use Illuminate\Foundation\Http\FormRequest;

class StoreVisitRateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
                 // class visit cart validation
            'data.class_visit_card.teacher_nationality_id' => 'nullable|exists:nationalities,id',
            'data.class_visit_card.teacher_qualification' => 'nullable|string',
            'data.class_visit_card.qualification_date' => 'required_with:data.class_visit_card.teacher_qualification|string',
            'data.class_visit_card.teaching_field' => 'nullable|string',
            'data.class_visit_card.direct_school_date' => 'nullable|string',
            'data.class_visit_card.direct_school_date_type' => ['required_with:direct_school_date','in:coptic,hijri'],
            'data.class_visit_card.visit_type' => 'nullable|in:supervisory',
            'data.class_visit_card.teacher_new_to_subject' => 'nullable|in:yes,no',
            'data.class_visit_card.visit_method_ids' => 'nullable|array',
            'data.class_visit_card.visit_method_ids.*' => 'integer|exists:visit_methods,id',
            'data.class_visit_card.additional_methods' => 'nullable|string',
                // class visit rate validation
            'data.class_visit_rate.school_class_id' => 'sometimes|exists:school_classes,id',
            'data.class_visit_rate.period_id' => 'sometimes|exists:periods,id',
            'data.class_visit_rate.subject_id' => 'sometimes|exists:subjects,id',
            'data.class_visit_rate.lesson_title_rate' => 'nullable|string',
            'data.class_visit_rate.number_of_class_students' => 'nullable|integer',
            'data.class_visit_rate.number_of_attendees' => 'nullable|integer',
            'data.class_visit_rate.number_of_absences' => 'nullable|integer',
            'data.class_visit_rate.visit_number' => 'nullable|integer',
            'data.class_visit_rate.purpose_of_visit' => 'nullable|string|max:255',

            'data.class_visit_rate.class_visit_meeting_teacher' => 'nullable|in:yes,no',
            'data.class_visit_rate.class_visit_meeting_teacher_desc' => 'nullable|string',

            'data.class_visit_rate.know_participation_subject_activities' => 'nullable|in:yes,no',
            'data.class_visit_rate.know_participation_subject_activities_desc' => 'nullable|string',

            'data.class_visit_rate.review_written_preparation_lesson' => 'nullable|in:yes,no',
            'data.class_visit_rate.review_written_preparation_lesson_desc' => 'nullable|string',

            'data.class_visit_rate.discussion_school_manager' => 'nullable|in:yes,no',
            'data.class_visit_rate.discussion_school_manager_desc' => 'nullable|string',

            'data.class_visit_rate.make_short_test_students_rate' => 'nullable|in:yes,no',
            'data.class_visit_rate.make_short_test_students_desc' => 'nullable|string',


            'data.class_visit_rate.view_assignments_applications' => 'nullable|in:yes,no',
            'data.class_visit_rate.view_assignments_applications_desc' => 'nullable|string',

            'data.class_visit_rate.visit_student_mentor' => 'nullable|in:yes,no',
            'data.class_visit_rate.visit_student_mentor_desc' => 'nullable|string',

            'data.class_visit_rate.view_calendar_tests' => 'nullable|in:yes,no',
            'data.class_visit_rate.view_calendar_tests_desc' => 'nullable|string',

            'data.class_visit_rate.responsibility_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.responsibility_desc' => 'nullable|string',
            'data.class_visit_rate.communication_collaboration_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.communication_collaboration_desc' => 'nullable|string',
            'data.class_visit_rate.adherence_dialogue_etiquette_verbally_and_writing_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.adherence_dialogue_etiquette_verbally_and_writing_desc' => 'nullable|string',
            'data.class_visit_rate.development_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.development_desc' => 'nullable|string',
            'data.class_visit_rate.exchanging_experiences_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.exchanging_experiences_desc' => 'nullable|string',
            'data.class_visit_rate.providing_knowledge_production_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.providing_knowledge_production_desc' => 'nullable|string',
            'data.class_visit_rate.design_course_plan_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.design_course_plan_desc' => 'nullable|string',
            'data.class_visit_rate.lesson_preparing_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.lesson_preparing_desc' => 'nullable|string',
            'data.class_visit_rate.preparation_learning_objectives_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.preparation_learning_objectives_desc' => 'nullable|string',
            'data.class_visit_rate.implementing_lesson_achieves_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.implementing_lesson_achieves_desc' => 'nullable|string',
            'data.class_visit_rate.employing_educational_techniques_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.employing_educational_techniques_desc' => 'nullable|string',
            'data.class_visit_rate.using_distance_education_platforms_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.using_distance_education_platforms_desc' => 'nullable|string',
            'data.class_visit_rate.providing_scientific_material_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.providing_scientific_material_desc' => 'nullable|string',
            'data.class_visit_rate.apply_educational_strategies_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.apply_educational_strategies_desc' => 'nullable|string',
            'data.class_visit_rate.linking_lesson_real_life_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.linking_lesson_real_life_desc' => 'nullable|string',
            'data.class_visit_rate.asking_appropriate_class_questions_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.asking_appropriate_class_questions_desc' => 'nullable|string',
            'data.class_visit_rate.involving_students_lesson_activities_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.involving_students_lesson_activities_desc' => 'nullable|string',
            'data.class_visit_rate.evaluating_learning_diagnose_student_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.evaluating_learning_diagnose_student_desc' => 'nullable|string',
            'data.class_visit_rate.building_integrated_plan_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.building_integrated_plan_desc' => 'nullable|string',
            'data.class_visit_rate.employing_classroom_applications_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.employing_classroom_applications_desc' => 'nullable|string',
            'data.class_visit_rate.creating_educational_environment_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.creating_educational_environment_desc' => 'nullable|string',
            'data.class_visit_rate.department_student_contributions_inquiries_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.department_student_contributions_inquiries_desc' => 'nullable|string',
            'data.class_visit_rate.managing_learning_time_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.managing_learning_time_desc' => 'nullable|string',
            'data.class_visit_rate.student_interaction_level_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.student_interaction_level_desc' => 'nullable|string',
            'data.class_visit_rate.student_achievement_level_rate' => 'nullable|integer|between:1,5',
            'data.class_visit_rate.student_achievement_level_desc' => 'nullable|string',

                // class visit recommendations validation
            'data.class_visit_recommendation.level_of_implementation_recommendations' => 'nullable|string',
            'data.class_visit_recommendation.strengths_and_excellence' => 'nullable|string',
            'data.class_visit_recommendation.supervisor_support' => 'nullable|string',
            'data.class_visit_recommendation.recommendation' => 'nullable|string',
            'data.class_visit_recommendation.teacher_benefit' => 'nullable|string',
                // class visit need validation
            'data.class_visit_need' => 'nullable|array',
            'data.class_visit_need.*.need' => 'nullable|string',
            'data.class_visit_need.*.recommended' => 'nullable|string',

        ];
    }
}
