<?php

namespace App\Http\Requests\ManagerDashboard\Circulars;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class TeacherGeneralCircularRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return[
            'school_id' => 'required|integer|exists:schools,id',
            'title' => 'required|string|max:255',
            'teachers' => 'required|array',
            'teachers.*' => ['integer', Rule::exists('school_employees', 'id')->where(function ($query) {
                $query->where('type', 'teacher');
            })],
        ];
    }

}
