<?php

namespace App\Http\Requests\AdminDashboard\School;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SchoolGradeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return[
            'name' => 'required|string|max:150',
            'status' =>['in:1,0'],
        ];
        
    }

    // Optionally, define custom error messages
    public function messages()
    {
        return [
            'name.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'يجب أن يكون الاسم نصًا.',
            'name.max' => 'يجب ألا يتجاوز الاسم 255 حرفًا.',
            'status.in' => 'يجيب ادخال قيمة 0 او 1',
        ];
    }

}
