<?php

namespace App\Http\Requests\AdminDashboard\Procedures;

use Illuminate\Foundation\Http\FormRequest;

class StoreLateProcedureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name_id' => ['required','integer','exists:procedure_names,id'],
            'late_form_id' => ['required', 'array'],
            'late_form_id.*' => ['required', 'exists:namazeg,id'],
            'late_dayes' => ['required','integer'],
            'status' =>['nullable','in:1,0'],
            'details'=>['nullable'],
        ];
    }

    public function messages()
    {
        return [
            'name_id.required' => 'حقل الاسم مطلوب.',
            'late_dayes.required' => 'يجب تحديد عدد ايام الغياب ' ,
            'late_dayes.integer' => 'يجب ان يكون عدد ايام الغياب رقم صحيح',
            'late_form_id.required' => 'يجب اختيار الإجراءات المراد تطبيقها.',
            'late_form_id.*.exists' => 'الإجراءات المراد تطبيقها غير موجودة.',
            'status.in' => 'يجيب ادخال قيمة 0 او 1',
        ];
    }
}
