<?php

namespace App\Http\Requests\AdminDashboard\BankAccount;

use Illuminate\Foundation\Http\FormRequest;

class StoreAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'bank_name' => ['required','string','min:3'],
            'account_name' => ['required','string','min:3'],
            'account_number' => ['required','digits_between:10,20','numeric','unique:bank_accounts,account_number'],
            'IBAN' => ['required','string','unique:bank_accounts,IBAN'],
            'logo' => ['nullable','mimes:png,jpg,jpeg'],
            'status' =>['nullable','in:1,0'],

        ];
    }
}
