<?php
namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use App\Http\Resources\User\PermissionResource;

class PermissionController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:permissions']);
    }

    /*
        -this method will return all Super Admin permissions
    */
    public function SuperAdminPermissions(){
        $permissions =PermissionResource::collection(Permission::where('parent_id',0)->where('type','super_admin')->get());
        return response()->json(['permissions_groups'=>$permissions,'message'=>trans('api.list of all available records')]);
    }

    /*
        -this method will return all School Manager permissions
    */
    public function SchoolManagerPermissions(){
        $permissions =PermissionResource::collection(Permission::where('parent_id',0)->where('type','school_manager')->get());
        return response()->json(['permissions_groups'=>$permissions,'message'=>trans('api.list of all available records')]);
    }

    /* this method will stord data to DB Model*/
    public function store(Request $request){
        if($request->permission_name){
            $permissionNames= explode(",", $request->permission_name);
            $permissionNamesAr= explode(",", $request->permission_name_ar);
            foreach($permissionNames as $key=>$permissionName){
                if (!Permission::where('name', $permissionName)->where('guard_name', 'api')->exists()) {
                    Permission::create(['name' => $permissionName,'name_ar'=>$permissionNamesAr[$key],'guard_name'=>'api','type'=>$request->type , 'parent_id',$request->parent_id]);
                }

            }
        }
        return response()->json(['message'=>trans('api.record stored successflly')]);
    }


    /* this method will update specific Model recored
        by using ID
    */
    public function updatePermission(Request $request){
        $permission =Permission::findOrFail($request->permission_id);
        /* update permission name*/
        $permission->name = $request->permission_name;
        $permission->parent_id = $request->parent_id;
        $permission->save();
        return response()->json(['message'=>trans('api.permission Name updated successflly')]);
    }

    /* this method will delete specific Model recored
        by using ID
    */
    public function deletePermission(Request $request){
        $permission =Permission::find($request->permission_id);

        /* delete sub permissions*/
        $subPermissions  = Permission::where('parent_id',$permission->id)->delete();

        /* delete main permissions*/
        $permission->delete();

        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }

}
