<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Validator;
use Str;
use Hash;
use App\Models\User;
use DB;
use Spatie\Permission\Models\Role;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\User\UserRoleResource;
use Illuminate\Support\Facades\Log;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\ManagerDashboard\Settings\TransactionPaymentGatewayData;
use Carbon\Carbon;

class EdfapayController extends Controller
{

    public function edfapay(Request $request)
    {

        $subscription_id = $request->subscription_id;

        $subscription = Subscription::where('id', $subscription_id)->firstOrFail();

        $timestamp = time();

        $order_number = str_pad($timestamp, 10, '0', STR_PAD_LEFT);

        $subscription->update([
            'order_number' => $order_number
        ]);


        $total_price = request()->amount;

        $PASSWORD = "6eea1e9749bb6b94378f6e4ef4d08a32";

        $hash = sha1(md5(strtoupper($subscription->order_number . $total_price . "SAR" . $subscription->product->name . $PASSWORD)));

        $curl = curl_init();
        $data = [
            'action' => "SALE",
            'edfa_merchant_id' => "f81e3bd1-b6bd-4f7b-b8eb-36da6487236b",
            'order_id' => $subscription->order_number,
            'order_amount' => $total_price,
            'order_currency' => "SAR",
            'order_description' => $subscription->product->name,
            'req_token' => "N",
            'payer_first_name' => $subscription->user->name,
            'payer_last_name' => "Null",
            'payer_address' => 'dsad',
            'payer_country' => "SA",
            'payer_city' => 'dasdas',
            'payer_zip' => "12221",
            'payer_email' => $subscription->user?->email,
            'payer_phone' => $subscription->user?->phone,
            'payer_ip' => "176.44.76.222",
            'term_url_3ds' => "https://digifly-dev.com/laam-lms/api/edfapay-result",
            'auth' => "N",
            'recurring_init' => "N",
            'hash' => $hash,
        ];

        // dd($data);
        //dd(json_encode($data));
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.edfapay.com/payment/initiate',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $data,
        ));

        $response = curl_exec($curl);

        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            dd("cURL Error #:" . $err);
        } else {
            $res = json_decode($response);
            return response()->json(['payment_url' => $res->redirect_url, 'message' => trans('api.please follow and redirect to payment page')]);
        }
    }


    public function edfapayCallback(Request $request)
    {
        Log::info('ramzy_test3:', ['data' => $request->all()]);

        if ($request->result == 'SUCCESS') {

            $timestamp = time();
            $transaction_number = str_pad($timestamp, 10, '0', STR_PAD_LEFT);

            $subscription = Subscription::where('order_number', $request->order_id)->firstOrFail();

            $transaction = TransactionPaymentGatewayData::create([
                'subscription_id' => $subscription->id,
                'order_amount' => $request->amount,
                'trans_date' => $request->trans_date,
                'transaction_number' => $transaction_number,

                // 'payment_method' => $request->payment_method,
            ]);

            $date = Carbon::now();

            $start_date = $date->format('d/m/Y');

            $end_date = $date->copy()->addYear()->format('d/m/Y');

            // Ensure the number is unique or prepend zeros to meet the format if necessary
            $timestamp = time();
            $generateInvoiceNumber = str_pad($timestamp, 10, '0', STR_PAD_LEFT);

            $subscription->update([
                'start_date' => $subscription->service_type == 'system' ? $start_date : null,
                'end_date' => $subscription->service_type == 'system' ? $end_date : null,
                'status' => 'subscribed',
                'paid_status' => 'paid',
                'paid_type' => 'payment_gateway',
                'invoice_number' => $generateInvoiceNumber
            ]);

            return response()->json([
                'message' => 'تم تأكيد الدفع بنجاح',
            ]);
        }
    }


    public function edfapayResult()
    {

        return response()->json([
            'message' => 'تم الدفع بنجاح',
        ]);

    }
}
