<?php

namespace App\Http\Controllers\Api\TeacherDashboard;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignmentMember;

class SupervisionCommiteeController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {

        $user = auth()->user();

        $schoolEmployee = SchoolEmployee::where('user_id', $user->id)->where('type', 'teacher')->first();

        if (!$schoolEmployee) {
            return response()->json(['error' => trans('api.you are not registered as school employee')], 404);
        }


        $current_school_year = School::findOrFail($schoolEmployee->school_id)->current_school_year;

        $assignment_member = CorrectionAssignmentMember::where('employee_id', $schoolEmployee->id)->first();

        if (!$assignment_member) {
            return response()->json(['data'=>[]], 404); 
        }

        $assignment = CorrectionAssignment::where('id', $assignment_member->assignment_id)->firstOrFail();

        return response()->json([
            'school_year' => $current_school_year,
            'subject' => $assignment->subject->name,
            'location' => $assignment->location,
            'members' => $assignment->members->map(function ($member) {
                return [
                    'id' => $member->employee->id,
                    'name' => $member->employee->name,
                    'role' => $member->assignment_work
                ];
            })
        ]);
    }
}
