<?php

namespace App\Http\Controllers\Api\TeacherDashboard;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\PeriodStudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentSeatingNumber;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use App\Models\Week;
use Carbon\Carbon;
use Illuminate\Http\Request;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;

class ReportController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:teacher-dashboard-report']);
    }

    public function studentAbsentLateReport(Request $request){
        $school = School::findOrFail($request->school_id);
        $semester = SchoolSemester::find($request->semester_id);
        $week = Week::find($request->week_id);
        $current_school_year = $school->current_school_year;
        $className = ClassName::find($request->class_name_id);

        $data =[
            'class_name'=>$className->name,
            'class_category'=>$className->category,
            'semester'=>$semester->name,
            'week'=>$week->name ,
            'current_school_year'=>$current_school_year,
            'absent_student_date'=>$this->transformStudentAbsentData($school->id , $semester->id , $week->id , $request->class_id),
        ];

        return response()->json(['data'=>$data,'message'=>trans('api.Report details')]);
    }


    private function transformStudentAbsentData($school_id , $semester_id , $week_id , $class_id){

        $students = Student::where('school_id',$school_id)->get();
        if (is_null($students)) {
            return [];
        }
        return $students->map(function ($student) use ($semester_id , $week_id ,$class_id) {
            $data=[
                'id'=>$student->id,
                'employee_name'=>$student->name,
                'ssn'=>$student->ssn,
            ];

            $startWeekDay =SemesterWeekDay::where('semester_id',$semester_id)->where('week_id',$week_id)->orderBy('id', 'asc')->first();
            $endWeekDay =SemesterWeekDay::where('semester_id',$semester_id)->where('week_id',$week_id)->orderBy('id', 'desc')->first();

            $absentWithExcuse = StudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$class_id)->where('status','absent_with_excuse')->count();
            $absentWithOutExcuse = StudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$class_id)->where('status','absent')->count();
            $absentWithExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$class_id)->where('status','absent_with_excuse')->count();
            $absentWithOutExcusePeriods = PeriodStudentAttendance::where('student_id',$student->id)->whereBetween('date',[$startWeekDay->date,$endWeekDay->date])->where('class_id',$class_id)->where('status','absent')->count();

            $data['absent_with_excuse']=$absentWithExcuse;
            $data['absent_without_excuse']=$absentWithOutExcuse;
            $data['absent_with_excuse_periods']=$absentWithExcusePeriods;
            $data['absent_without_excuse_periods']=$absentWithOutExcusePeriods;

            // Parse dates correctly based on format
            $startWeekDayDate = Carbon::createFromFormat('d/m/Y', $startWeekDay->date);
            $endWeekDayDate = Carbon::createFromFormat('d/m/Y', $endWeekDay->date);

            $currentDate = $startWeekDayDate->copy();
            while ($currentDate->lte($endWeekDayDate)) {
                $dayName = $currentDate->format('l');
                $date = $currentDate->format('d/m/Y');

                $absent = StudentAttendance::where('student_id', $student->id)
                    ->where('date', $date)
                    ->where('class_id', $class_id)
                    ->where('status', 'absent')
                    ->exists();

                $absent_with_excuse = StudentAttendance::where('student_id', $student->id)
                    ->where('date', $date)
                    ->where('class_id', $class_id)
                    ->where('status', 'absent_with_excuse')
                    ->exists();
                $dailyAttendance[] = [
                    'day' => $dayName,
                    'date' => $date,
                    'absent'=>$absent? trans('api.absent'):'',
                    'absent_with_excuse'=>$absent_with_excuse? trans('api.absent_with_excuse'):'',
                ];

                // Move to the next day
                $currentDate->addDay();
            }
            $data['daily_attendance']=$dailyAttendance;
            return $data;
        })->all();
    }

}
