<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Tasks;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Tasks\TaskStoreRequest;
use App\Http\Resources\ManagerDashboard\Tasks\TaskResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlaneDetails;
use App\Models\ManagerDashboard\Tasks\Task;
use Illuminate\Http\Request;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Carbon\Carbon;

class TaskController extends Controller
{
    use LogsActivity, NamazegTrait;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:tasks']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(School $school, Request $request)
    {
        $today = date('d/m/Y');
        $tasks = Task::where('date', $today)->where(function ($query) use ($school) {
            $query->where('school_id', $school->id)
                ->orWhereNull('school_id');
        })->get();
        $data_resource = TaskResource::collection($tasks);
        return response()->json(['today' => $today, 'n_tasks' => count($data_resource), 'tasks' => $data_resource]);
    }



    /* this method will stord data to DB Model*/

    public function store(TaskStoreRequest $request, School $school)
    {
        $data = $request->all();
        $date = $request->date;

        if ($data['date_type'] == 'hijri') {
            $date = Helper::getCoptic($data['date']);
        }
        $date = Carbon::createFromFormat('d/m/Y', $date);
        if ($date->lt(Carbon::today())) {
            return response()->json(['message' => __('api.The date must be today or in the future.')], 422);
        }


        $dayOfWeekCustom =  $date->dayOfWeek + 1;

        $data['date'] = $date->format('d/m/Y');

        $semester = null;

        while (!$semester) {
            $semester = SemesterWeekDay::where('date', $date->format('d/m/Y'))->first();

            if ($semester) {
                $data['semester_id'] = $semester->semester_id;
            }
            $date = $date->subDays(1);
        }
        $data['school_id'] = $school->id;
        unset($data['date_type']);

        if ($request->appointed == "1" && $semester->semester_id == 4) {
            return response()->json(['message' => 'لا يمكن اضافة فكرة مواعيد فى ايام خارج الفصل الدراسى'], 422);
        }
        $task = Task::create($data);

        $manager_plan = NamazegManagerPlane::where('school_id', $school->id)->where('semester_id', $semester->semester_id)
            ->where('week_id', $semester->week_id)->first();
        if ($manager_plan) {
            NamazegManagerPlaneDetails::create([
                'namazeg_manager_plane_id' => $manager_plan->id,
                'work_details' => $request->details,
                'type' => "suggested_work",
                'days' => json_encode([$dayOfWeekCustom], true),
                'task_id' => json_encode([$task->id]),
                'achieved' => json_encode([])

            ]);
        }
        $this->ManagerlogActivity('Task', 'store', $school->id, 131);
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
    by using ID
    */
    public function update(Task $task)
    {
        $date = Carbon::createFromFormat('d/m/Y', $task->date);
        $day_id_target = SemesterWeekDay::where('date', $task->date)->first()?->day_id;
        $plan_manager = NamazegManagerPlaneDetails::whereRaw('JSON_CONTAINS(task_id, ?)', [json_encode($task->id)])->first();

        if ($plan_manager) {
            $days = $plan_manager->days ? json_decode($plan_manager->days, true) : [];
            $achieveds = $plan_manager->achieved ? json_decode($plan_manager->achieved, true) : [];
            if (!$task->achieved) {
                // will make task achieved
                if (!in_array($day_id_target, $days)) {
                    $days[] = $day_id_target; // Add the new day
                }
                //add day
                if ($day_id_target) {
                    if (!in_array($day_id_target, $days)) {
                        $days[] = $day_id_target;
                    }
                }

                $plan_manager->days = json_encode(array_values($days));
            } else {
                $plan_manager->days = json_encode(array_values($days));
            }
            foreach ($days as $day_key => $day_id) {
                if ($day_id_target == $day_id) {
                    $day_key;
                    break;
                }
            }
            $achieveds = in_array($day_id_target, $achieveds)
                ? array_filter($achieveds, fn($day) => $day !== $day_id_target)
                : array_merge($achieveds, [$day_id_target]);

            $plan_manager->achieved = json_encode(array_values($achieveds));

            $plan_manager->save();
        }
        // !$task->achieved -> يعنى هيخليها انتهت لوهى مش منتهية -> true mean will be finsihed
        $state = !$task->achieved ? 'achieved' : 'undo';
        $task->update(['achieved' => !$task->achieved]);
        $this->ManagerlogActivity('Task', $state, $task->school_id, 131);
        return response()->json(['message' => trans('api.record updated successflly')]);
    }
}
