<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\Payment;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Setting\BankTransfer\StoreBankTransferDataRequest;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\ManagerDashboard\Settings\TransactionBankdata;
use Carbon\Carbon;
use Illuminate\Http\Request;

class TransactionBankController extends Controller
{
  
    /**
     * Handle the incoming request.
     */
    public function __invoke(StoreBankTransferDataRequest $request, Subscription $subscription)
    {

        $data = $request->validated();

        $date = Carbon::createFromFormat('d/m/Y', $data['transfer_date'])->format('d/m/Y');
        $date_type = $data['date_type'];

        if ($date_type === 'hijri') {
            $date = Helper::getCoptic($date);
            $date_type = 'coptic';
        }

        if (request()->hasFile('transfer_receipt')) {
            $fileName = Helper::uploadImage('TransferReceipts', request()->file('transfer_receipt'));
        }

        // Ensure the number is unique or prepend zeros to meet the format if necessary
        $timestamp = time();
        $generate_order_number = str_pad($timestamp, 10, '0', STR_PAD_LEFT);

        TransactionBankdata::create([
            'subscription_id' => $subscription->id,
            'bank_account_id' => $data['bank_account_id'],
            'transfer_date' => $date,
            'transfer_receipt'  => $fileName
        ]);

        $subscription->update([
            'paid_type' => 'bank_transfer',
            'paid_status' => 'pending',
            'order_number' => $generate_order_number,
        ]);

        return response()->json([
            'message' => 'تمت العمليه بنجاح في انتظار التاكيد',
        ]);
    }
}
