<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions;

use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\Coupons\Coupon;
use App\Models\AdminDashboard\Products\Product;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ApplyCouponController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
      
        // Validate request data
        $data = $request->validate([
            'coupon' => 'required|string|exists:coupons,code',
            'product_id' => ' required|numeric|min:0',
        ]);

        $subscription_fee = Product::where('id',$data['product_id'])->firstOrFail()->price;
      
        // Fetch the coupon
        $coupon = Coupon::where('code', $data['coupon'])->firstOrFail();

        


        // Calculate the discount amount
        $discount_amount = ($coupon->discount_type === 'fixed')
            ? min($coupon->discount_value, $subscription_fee ) // Ensure discount doesn't exceed fee
            : $subscription_fee  * $coupon->discount_value / 100;

        // Calculate the total after discount
        $total_after_discount = max(0, $subscription_fee  - $discount_amount);

        // Return success response
        return response()->json([
            'message' => 'تم تفعيل الكود بنجاح',
            'coupon_id' => $coupon->id,
            'discount_amount' => $discount_amount,
            'total_after_discount' => $total_after_discount,
        ]);
    }
}
