<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Reports;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative\EducationalAdminstrativeAlertReportResource;
use App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative\EducationalAdminstrativeClassVisitReportResource;
use App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative\EducationalAdminstrativeWorkReportResource;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\AdministrativeWorkReportResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeClassVisit;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork;
use Illuminate\Http\Request;
use JWTAuth;
use Carbon\Carbon;

class EducationalAdmisnstrativeContoller extends Controller
{

    public function storeWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',6)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 9;
        $data['namazeg_version_id'] = NULL;
        $report = EducationalAdminstrativeWork::create($data);
        $report = new EducationalAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',7)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= EducationalAdminstrativeWork::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new EducationalAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    public function getAllWorkReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = EducationalAdminstrativeWork::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type','report_category']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeWork', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = EducationalAdminstrativeWorkReportResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    public function storeClassVisitReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',6)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 10;
        $data['namazeg_version_id'] = NULL;
        $report = EducationalAdminstrativeClassVisit::create($data);
        $report = new EducationalAdminstrativeClassVisitReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getClassVisitReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',6)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= EducationalAdminstrativeClassVisit::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new EducationalAdminstrativeClassVisitReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    public function getAllClassVisitReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = EducationalAdminstrativeClassVisit::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','semester_id']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeClassVisit', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate);
        }

        if ($request->semester_id) {
            $data->where('semester_id', $request->semester_id);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = EducationalAdminstrativeClassVisitReportResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }


    public function storeAlertReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',6)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 11;
        $data['namazeg_version_id'] = NULL;
        $report = EducationalAdminstrativeAlert::create($data);
        $report = new EducationalAdminstrativeAlertReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getAlertReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',6)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= EducationalAdminstrativeAlert::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new EducationalAdminstrativeAlertReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    public function getAllAlertReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = EducationalAdminstrativeAlert::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','semester_id']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate);
        }

        if ($request->semester_id) {
            $data->where('semester_id', $request->semester_id);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = EducationalAdminstrativeAlertReportResource::collection($data->paginate($perPage));
        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

}
