<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Namazeg;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use App\Services\NamazegService;
use App\Traits\NamazegTrait;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;


class NamazegDataController extends Controller
{
    use NamazegTrait;
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:notifications']);
    }

    // --------------------  To Get data for static Namazeg ----------------------------------- 
    public static function get_data($school_id, $form_number)
    {
        $namozeg = Namazeg::where('form_number', $form_number)->firstOrFail();
        $response_data = [];
        // Array of form numbers that require service handling
        $form_numbers_with_service = [69, 70, 71, 72, 73, 74, 76, 77, 78, 79, 80, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 99, 100, 101, 102, 103, 104, 105, 106, 107];

        if (in_array($form_number, $form_numbers_with_service)) {
            $namazegService = new NamazegService();
            $data = $namazegService->getNamazegData($form_number, $school_id);

            if (!$data) {
                // Handle the case when no data is found
                return response()->json(['message' => 'No data found for this form number'], 404);
            }

            // Return or process the data as needed
            return response()->json(['data' => $data,'form_number'=> $form_number]);
        }


      
        if (!$namozeg) {
            $response_data = [
                'schools' => [
                    'current_school_year' => School::findOrFail($school_id)->current_school_year
                ],
                'form_number'=> $form_number
            ];
            return response()->json($response_data);
        }

        $data = $namozeg->data;
        if (isset($data['basic_models'])) {
            foreach ($data['basic_models'] as $basic_model) {
                if (!isset($basic_model['belongsTo'])) {
                    if ($basic_model['table'] != "schools") {
                        $query = DB::table($basic_model['table'])->where('school_id', $school_id);
                    } else {
                        $query = DB::table($basic_model['table'])->where('id', $school_id);
                    }
                } else {
                    if ($basic_model['belongsTo']['model'] != "schools") {
                        $model_depend = DB::table($basic_model['belongsTo']['model'])->where('school_id', $school_id);
                    } else {
                        $model_depend = DB::table($basic_model['belongsTo']['model'])->where('id', $school_id);
                    }

                    if ($basic_model['belongsTo']['model'] === "schools") {
                        $school = DB::table($basic_model['belongsTo']['model'])->where('id', $school_id)->first();
                        $parent_model_attribute = $basic_model['belongsTo']['attr'];
                        $model_depend_value = $school->$parent_model_attribute;
                        $query = DB::table($basic_model['table'])->where('id', $model_depend_value);
                    } else {
                        // Handle other models if required
                        $model_depend = DB::table($basic_model['belongsTo']['model'])->where('school_id', $school_id);
                        $model_depend_value = $model_depend->first();
                        $query = DB::table($basic_model['table'])->where('id', $model_depend_value->{$basic_model['belongsTo']['attr']});
                    }
                }
                if (isset($basic_model['where'])) {
                    foreach ($basic_model['where'] as $where_condition) {
                        $query = $query->where(
                            $where_condition['attr'],
                            $where_condition['operator'],
                            $where_condition['value']
                        );
                    }
                }


                $query = $query->select($basic_model['select']);

                if ($basic_model['method'] === 'get') {
                    $results = $query->get();
                } elseif ($basic_model['method'] === 'first') {
                    $results = $query->first();
                }

                if (isset($basic_model['withkeys']) && is_array($basic_model['withkeys'])) {
                    $mapped_results = [];

                    if ($basic_model['method'] === 'get') {
                        // For multiple results, map each result
                        foreach ($results as $result) {
                            $mapped_results[] = self::map_withkeys($result, $basic_model);
                        }
                    } else {
                        // For a single result, map the single result
                        $mapped_results = self::map_withkeys($results, $basic_model);
                    }

                    $response_data[$basic_model['withkeys'][0]] = $mapped_results;
                } else {
                    $response_data[$basic_model['table']] = $results;
                }

                // Use the table name as the key in the response array
                // $response_data[$basic_model['table']] = $results;
            }
        }

        if (isset($data['helper'])) {
            foreach ($data['helper'] as $helper_method) {
                // $query = Helper::$helper_method['methode'];
                $query = Helper::{$helper_method['method']}();
                if (isset($helper_method['attr'])) {
                    $data = $query->{$helper_method['attr']};
                } else {
                    $data = $query;
                }

                if (isset($helper_method['withkeys'])) {
                    $mapped_results = [];

                    if (is_array($helper_method['withkeys'])) {
                        // For multiple results, map each result
                        foreach ($helper_method['withkeys'] as $key) {
                            $response_data[$key] = $data;
                        }
                    }
                }
            }
        }
        $response_data['form_number']=$form_number;
        return response()->json($response_data);
    }

    private static  function map_withkeys($result, $basic_model)
    {
        $mapped_result = [];

        foreach ($basic_model['select'] as $index => $field) {
            // Use 'withkeys' if available, otherwise fallback to the field name
            $key_name = $basic_model['withkeys'][$index] ?? $field;
            $mapped_result[$key_name] = $result?->$field;
        }

        return $mapped_result;
    }
    // --------------------  To Get data for static Namazeg ----------------------------------- 




}
