<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Namazeg;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Namazeg\AbsenceDescionConfirmStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\AbsenceQuestioningStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\AcceptStudentStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\AssignProfessionalCommunitiesStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\AssignProfessionalCommunitiesUpdateRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\BooksDeliveryStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\CircularAttendanceReportStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\ClassPlanActivityStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\DescionSumHoursRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\EmployeeLeavingRecordStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\EvacuationRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\GuardianTransFromRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\MaintenanceFormRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\ManagerPlanStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\MoniteringLateTeacherRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\NotifyLateLeavingRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\QuestioningStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\ReportClassPlanActivityStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\SchoolCommittmentStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\StudentDataStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\StudentFollowStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\TeacherExcuseDayRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\TeacherPerformanceStoreRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\TransformQuroanStudentStoreRequest;
use App\Http\Resources\ManagerDashboard\Namazeg\AbsenceDescionConfirmResource;
use App\Http\Resources\ManagerDashboard\Namazeg\AbsenceQuestioningResource;
use App\Http\Resources\ManagerDashboard\Namazeg\AcceptStudentResource;
use App\Http\Resources\ManagerDashboard\Namazeg\AssignProfessionalResource;
use App\Http\Resources\ManagerDashboard\Namazeg\BookDeliveryResource;
use App\Http\Resources\ManagerDashboard\Namazeg\DescionSumHoursResource;
use App\Http\Resources\ManagerDashboard\Namazeg\EmployeeLeavingRecordResource;
use App\Http\Resources\ManagerDashboard\Namazeg\EvacuationimagesResource;
use App\Http\Resources\ManagerDashboard\Namazeg\FollowStudentResource;
use App\Http\Resources\ManagerDashboard\Namazeg\GuardianTransFromRequestResource;
use App\Http\Resources\ManagerDashboard\Namazeg\MaintenanceFormResource;
use App\Http\Resources\ManagerDashboard\Namazeg\MoniteringLateTeacherResource;
use App\Http\Resources\ManagerDashboard\Namazeg\NamazegPlaneResource;
use App\Http\Resources\ManagerDashboard\Namazeg\NotifyLateLeavingResource;
use App\Http\Resources\ManagerDashboard\Namazeg\PlanActivityResource;
use App\Http\Resources\ManagerDashboard\Namazeg\QuestioningResource;
use App\Http\Resources\ManagerDashboard\Namazeg\ReportPlanActivityResource;
use App\Http\Resources\ManagerDashboard\Namazeg\SchoolCommitmentResource;
use App\Http\Resources\ManagerDashboard\Namazeg\TeacherPerformanceFollowResource;
use App\Http\Resources\ManagerDashboard\Namazeg\TransferQuranResource;
use App\Http\Resources\ManagerDashboard\Namazeg\CircularAttendanceReportResource;
use App\Http\Resources\ManagerDashboard\Namazeg\NamazegTaskResource;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\AdminDashboard\School\Student;
use App\Models\AdminDashboard\School\Subject;
use App\Models\ManagerDashboard\MediaSuggestions\MediaSuggestion;
use App\Models\ManagerDashboard\Namazeg\AbsenceQuestioningAction;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceDescionConfirm;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegAcceptStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunities;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunitiesEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegBooksDelivery;
use App\Models\ManagerDashboard\Namazeg\NamazegChemistLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegClassPlanActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegDescionSumhoursLateleaving;
use App\Models\ManagerDashboard\Namazeg\NamazegEmployeeLeavingRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanImages;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanReport;
use App\Models\ManagerDashboard\Namazeg\NamazegExcessDamageRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentExcutionRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentsPlan;
use App\Models\ManagerDashboard\Namazeg\NamazegFinalReportClassActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegGuardianTransFrom;
use App\Models\ManagerDashboard\Namazeg\NamazegLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegMaintenanceForm;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlaneDetails;
use App\Models\ManagerDashboard\Namazeg\NamazegMonitoringLateAbsenceTeacher;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegRecieptRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegSchoolCommitment;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentData;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherExcuse;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherPerformanceFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTransformQuranStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Tasks\Task;
use App\Models\Namazeg;
use App\Providers\NamozegServiceProvider;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;

class NamazegController extends Controller
{
    use NamazegTrait, LogsActivity;
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:notifications']);
    }

    public static function get_namozeg_data($school_id, Request $request)
    {
        // Find the school and the namozeg version
        $school = School::findOrFail($school_id);
        $namazeg_version = NamazegVersion::with('namozeg')
            ->where('serial_number', $request->serial_number)
            ->firstOrFail();

        $form_number = $namazeg_version->namozeg->form_number;

        // Use the NamozegServiceProvider to handle the form
        $namozegService = new NamozegServiceProvider();
        $result = $namozegService->handleForm($form_number, $school, $request, $namazeg_version, $request->type);
        $result['form_number'] = $form_number;

        return response()->json($result);
    }



    //129 بيان إطلاع الموظفات على التعاميم
    // داخلى
    public function get_circular_attendance_report(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $circulars = NamazegCircularAttendance::with('namozegVersion')->where('school_id', $school_id)->paginate($perPage);
        $circulars_resource = CircularAttendanceReportResource::collection($circulars);
        return response()->json([
            'data' => $circulars_resource
        ]);
    }
    public function store_circular_attendance_report(CircularAttendanceReportStoreRequest $request)
    {

        $namozeg = Namazeg::where('form_number', '129')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $request->school_id
        );
        $circulars = NamazegCircularAttendance::create([
            'school_id' => $request->school_id,
            "code" => $request->code,
            'date' => $request->date_type == 'coptic' ? $request->date : Helper::getCoptic($request->date),
            'issued_by' => $request->issued_by,
            'about' => $request->about,
            'directed_to' => $request->directed_to,
            'namazeg_version_id' => $namozeg_version->id
        ]);
        $this->ManagerlogActivity('NamazegCircularAttendance', 'store', $request->school_id, 129);
        return response()->json([
            'data' => $circulars
        ]);
    }

    public function delete_circular_attendance_report(NamazegCircularAttendance $NamazegCircularAttendance)
    {
        $NamazegCircularAttendance->delete();
        $this->ManagerlogActivity('NamazegCircularAttendance', 'delete', $NamazegCircularAttendance->school_id, 129);
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    // ---------------------------------
    //خطة المدير 131 
    // داخلى
    public function get_manager_plans(Request $request, $school_id)
    {
        $queryParams = $request->query();
        Helper::managerPLans($school_id);
        $perPage = $queryParams['per_page'] ?? 51;
        $plans = NamazegManagerPlane::with('week', 'semester')
        ->where('school_id', $school_id);

        if (!$plans->exists()) {
            Helper::managerPlans($school_id);
            $plans = NamazegManagerPlane::with('week', 'semester')
                ->where('school_id', $school_id);
        }
        $plans = $plans->paginate($perPage);

        $plane_resource = NamazegPlaneResource::collection($plans);

        // Group the plans by semester and format them as arrays
        $grouped_by_semester = $plane_resource->groupBy(function ($item) {
            return $item->semester['id']; // Group by semester_id
        });
        $sorted_by_semester = $grouped_by_semester->sortKeys();

        // Convert the grouped data into an array of arrays with the semester name inside the data
        $formatted_data = [];
        foreach ($sorted_by_semester as $semester_id => $plans) {
            $semester_name = $plans->first()->semester['name']; // Get the semester name from the first item in the group
            $formatted_data[] = [
                'semester_id' => $semester_id,  // Add semester_id
                'semester' => $semester_name,   // Add semester name
                'plans' => $plans->values()->toArray(), // Ensure it's a numeric array of plans
            ];
        }
        return response()->json([
            'data' => $formatted_data
        ]);
    }


    public function store_manager_plans(ManagerPlanStoreRequest $request, $school_id, $manager_plane_id)
    {
        $namazeg_manager_plane = NamazegManagerPlane::findOrFail($manager_plane_id);
        $old_plan_data = NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $manager_plane_id)->get();

        $old_task_ids = $old_plan_data->flatMap(function ($plan) {
            return json_decode($plan->task_id, true) ?? [];
        })->toArray();
        Task::whereIn('id', $old_task_ids)->delete();
        NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $manager_plane_id)->delete();
        foreach ($request->work_to_be_done as $data) {
            $required_days = collect($data['days']);
            $achieved_days = collect($data['achieved']);
            $task_ids = [];
            foreach ($achieved_days as $achieved_day) {
                $day = SemesterWeekDay::where('semester_id', $namazeg_manager_plane->semester_id)
                    ->where('week_id', $namazeg_manager_plane->week_id)
                    ->where('day_id', $achieved_day)->first();
                if ($day) {
                    $task = Task::updateOrCreate([
                        'date' => $day->date,
                        'details' => $data['work_details'],
                        'school_id' => $school_id,
                        'semester_id' => $namazeg_manager_plane->semester_id,
                    ], [
                        'appointed' => 0,
                        'achieved' => 1,
                    ]);
                    $task_ids[] = $task->id;
                }
            }
            NamazegManagerPlaneDetails::create([
                'namazeg_manager_plane_id' => $manager_plane_id,
                'work_details' => $data['work_details'],
                'type' => "work_to_be_done",
                'days' => json_encode($data['days']),
                'achieved' => json_encode($achieved_days),
                'task_id' => json_encode($task_ids)
            ]);
        }

        foreach ($request->suggested_work as $suggest_data) {
            $required_days = collect($suggest_data['days']);
            $suggested_achieved_days = collect($suggest_data['achieved']);
            $suggest_task_ids = [];
            foreach ($suggested_achieved_days as  $achieved_day) {
                $day = SemesterWeekDay::where('semester_id', $namazeg_manager_plane->semester_id)
                    ->where('week_id', $namazeg_manager_plane->week_id)
                    ->where('day_id', $achieved_day)->first();
                if ($day) {
                    $task = Task::updateOrCreate([
                        'date' => $day->date,
                        'details' => $suggest_data['work_details'],
                        'school_id' => $school_id,
                        'semester_id' => $namazeg_manager_plane->semester_id,
                    ], [
                        'appointed' => 0,
                        'achieved' => 1,
                    ]);
                    $suggest_task_ids[] = $task->id;
                }
            }
            NamazegManagerPlaneDetails::create([
                'namazeg_manager_plane_id' => $manager_plane_id,
                'work_details' => $suggest_data['work_details'],
                'type' => "suggested_work",
                'days' => json_encode($suggest_data['days']),
                'achieved' => json_encode($suggested_achieved_days),
                'task_id' => json_encode($suggest_task_ids)
            ]);
        }
        $namazeg_manager_plane->status = "done";
        $namazeg_manager_plane->save();
        $this->ManagerlogActivity('NamazegManagerPlane', 'store', $school_id, 131);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_manager_plans(ManagerPlanStoreRequest $request, $school_id, $manager_plane_id)
    {
        $namazeg_manager_plane = NamazegManagerPlane::findOrFail($manager_plane_id);
        $old_plan_data = NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $manager_plane_id)->get();

        $old_task_ids = $old_plan_data->flatMap(function ($plan) {
            return json_decode($plan->task_id, true) ?? [];
        })->toArray();
        Task::whereIn('id', $old_task_ids)->delete();
        NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $manager_plane_id)->delete();
        foreach ($request->work_to_be_done as $data) {
            $achieved_days = collect($data['achieved']);
            $task_ids = [];
            foreach ($achieved_days as $achieved_day) {
                $day = SemesterWeekDay::where('semester_id', $namazeg_manager_plane->semester_id)
                    ->where('week_id', $namazeg_manager_plane->week_id)
                    ->where('day_id', $achieved_day)->first();
                if ($day) {
                    $task = Task::updateOrCreate([
                        'date' => $day->date,
                        'details' => $data['work_details'],
                        'school_id' => $school_id,
                        'semester_id' => $namazeg_manager_plane->semester_id,
                    ], [
                        'appointed' => 0,
                        'achieved' => 1,
                    ]);
                    $task_ids[] = $task->id;
                }
            }

            NamazegManagerPlaneDetails::create([
                'namazeg_manager_plane_id' => $manager_plane_id,
                'work_details' => $data['work_details'],
                'type' => "work_to_be_done",
                'days' => json_encode($data['days']),
                'achieved' => json_encode($achieved_days),
                'task_id' => json_encode($task_ids)
            ]);
        }

        foreach ($request->suggested_work as $suggest_data) {
            $suggested_achieved_days = collect($suggest_data['achieved']);
            $suggest_task_ids = [];
            $task_ids = [];
            foreach ($suggested_achieved_days as $suggested_achieved_day) {
                $day = SemesterWeekDay::where('semester_id', $namazeg_manager_plane->semester_id)
                    ->where('week_id', $namazeg_manager_plane->week_id)
                    ->where('day_id', $suggested_achieved_day)->first();
                if ($day) {
                    $task = Task::updateOrCreate([
                        'date' => $day->date,
                        'details' => $data['work_details'],
                        'school_id' => $school_id,
                        'semester_id' => $namazeg_manager_plane->semester_id,
                    ], [
                        'appointed' => 0,
                        'achieved' => 1,
                    ]);
                    $suggest_task_ids[] = $task->id;
                }
            }

            NamazegManagerPlaneDetails::create([
                'namazeg_manager_plane_id' => $manager_plane_id,
                'work_details' => $suggest_data['work_details'],
                'type' => "suggested_work",
                'days' => json_encode($suggest_data['days']),
                'achieved' => json_encode($suggested_achieved_days),
                'task_id' => json_encode($suggest_task_ids)
            ]);
        }
        $namazeg_manager_plane->status = "done";
        $namazeg_manager_plane->save();
        $this->ManagerlogActivity('NamazegManagerPlane', 'store', $school_id, 131);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_manager_plans(NamazegManagerPlane $NamazegManagerPlane)
    {
        $old_plan_data = NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $NamazegManagerPlane->id)->get();

        $old_task_ids = $old_plan_data->flatMap(function ($plan) {
            return json_decode($plan->task_id, true) ?? [];
        })->toArray();
        Task::whereIn('id', $old_task_ids)->delete();
        NamazegManagerPlaneDetails::where('namazeg_manager_plane_id', $NamazegManagerPlane->id)->delete();

        $NamazegManagerPlane->update(['status' => 'notDone']);

        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    public function get_tasks_plans(Request $request, School $school, SchoolSemester $semester)
    {
        $tasks = Task::where('school_id', $school->id)
            ->where('appointed', 1)
            ->where('semester_id', $semester->id);
        $perPage = $request->per_page ?? 15;
        $data_resource = NamazegTaskResource::collection($tasks->paginate($perPage));
        return response()->json([
            'current_school_year' => $school->current_school_year,
            'data' => $data_resource
        ]);
    }
    public function get_media_suggestions(School $school, SchoolSemester $semester)
    {
        $media = MediaSuggestion::where('school_id', $school->id)->where('semester_id', $semester->id)->first();
        return response()->json([
            'current_school_year' => $school->current_school_year,
            "details" => $media ? $media->details : null
        ]);
    }
    public function store_media_suggestions(Request $request, School $school, SchoolSemester $semester)
    {

        MediaSuggestion::updateOrCreate(
            [
                'school_id' => $school->id,
                'semester_id' => $semester->id,
            ],
            [
                'details' => $request->details
            ]
        );
        $this->ManagerlogActivity('MediaSuggestion', 'update', $school->school_id, 131);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    // ---------------------------------
    //سجل دوام الموظفات
    public function circular_attendance($school_id)
    {
        $school = School::findOrFail($school_id);
        return response()->json([
            'current_school_year' => $school->current_school_year
        ]);
    }

    // ------------------------------------------------------------------------
    //135 teachingThing
    //سجل متابعة آداء المعلمة
    // داخلى
    public function get_teacher_performance(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $teacher_performance = NamazegTeacherPerformanceFollow::with('employee')->where('school_id', $school_id)->paginate($perPage);
        $teacher_performance_resource = TeacherPerformanceFollowResource::collection($teacher_performance);

        return response()->json([
            'data' => $teacher_performance_resource
        ]);
    }

    public function store_teacher_performance(TeacherPerformanceStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '135')->first();
        foreach ($request->school_employee_id as $school_employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegTeacherPerformanceFollow::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'school_employee_id' => $school_employee_id
            ]);
        }
        $this->ManagerlogActivity('NamazegTeacherPerformanceFollow', 'store', $school_id, 135);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }

    public function delete_teacher_performance(NamazegTeacherPerformanceFollow $NamazegTeacherPerformanceFollow)
    {
        $this->ManagerlogActivity('NamazegTeacherPerformanceFollow', 'delete', $NamazegTeacherPerformanceFollow->school_id, 135);
        $NamazegTeacherPerformanceFollow->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //تكليف فريق مجتمعات التعلم المهنية
    // داخلى
    public function get_assign_professional_communities(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $assigns = NamazegAssignProfessionalCommunities::with('assign_employee', 'specialization')->where('school_id', $school_id)->paginate($perPage);
        $assigns_resource = AssignProfessionalResource::collection($assigns);

        return response()->json([
            'data' => $assigns_resource
        ]);
    }
    public function store_assign_professional_communities(AssignProfessionalCommunitiesStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '136')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;
        $start_date = $request->start_date_type == 'hijri' ? Helper::getCoptic($request->start_date) : $request->start_date;

        $NamazegAssign = NamazegAssignProfessionalCommunities::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'date' => $date,
            'start_date' => $start_date,
            'specialize_id' => $request->specialize_id
        ]);
        foreach ($request->data as $data) {
            NamazegAssignProfessionalCommunitiesEmployee::create([
                'namazeg_assign_id' => $NamazegAssign->id,
                'emplyee_id' => $data['employee_id'],
                'assignment_details' => $data['assignment_details'],
                'class_teaching' => $data['class_teaching']
            ]);
        }
        $this->ManagerlogActivity('NamazegAssignProfessionalCommunities', 'store', $school_id, 136);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_assign_professional_communities(AssignProfessionalCommunitiesUpdateRequest $request, NamazegAssignProfessionalCommunities $ProfessionalCommunities)
    {
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;
        $start_date = $request->start_date_type == 'hijri' ? Helper::getCoptic($request->start_date) : $request->start_date;

        $ProfessionalCommunities->update([
            'date' => $date,
            'start_date' => $start_date,
            'specialize_id' => $request->specialize_id
        ]);
        NamazegAssignProfessionalCommunitiesEmployee::where('namazeg_assign_id', $ProfessionalCommunities->id)->delete();
        foreach ($request->data as $data) {
            NamazegAssignProfessionalCommunitiesEmployee::create([
                'namazeg_assign_id' => $ProfessionalCommunities->id,
                'emplyee_id' => $data['employee_id'],
                'assignment_details' => $data['assignment_details'],
                'class_teaching' => $data['class_teaching']
            ]);
        }
        $this->ManagerlogActivity('NamazegAssignProfessionalCommunities', 'update', $ProfessionalCommunities->school_id, 136);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }

    public function delete_assign_professional_communities(NamazegAssignProfessionalCommunities $AssignProfessionalCommunities)
    {
        $this->ManagerlogActivity('NamazegAssignProfessionalCommunities', 'delete', $AssignProfessionalCommunities->school_id, 136);
        $AssignProfessionalCommunities->delete();

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //137 مساءلة
    // داخلى
    public function get_questioning(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $questions = NamazegQuestioning::with('employee', 'namozegVersion')->where('school_id', $school_id)->paginate($perPage);
        $questions_resource = QuestioningResource::collection($questions);

        return response()->json([
            'data' => $questions_resource
        ]);
    }
    public function store_questioning(QuestioningStoreRequest $request, $school_id)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        $namozeg = Namazeg::where('form_number', '137')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;
        NamazegQuestioning::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'user_id' => $user->id,
            'date' => $date,
            'employee_id' => $request->employee_id,
            'details' => json_encode($request->details)
        ]);
        $this->ManagerlogActivity('NamazegQuestioning', 'store', $school_id, 137);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_questioning(QuestioningStoreRequest $request, NamazegQuestioning $NamazegQuestioning)
    {

        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;
        $NamazegQuestioning->update([
            'date' => $date,
            'employee_id' => $request->employee_id,
            'details' => json_encode($request->details)
        ]);
        $this->ManagerlogActivity('NamazegQuestioning', 'update', $NamazegQuestioning->school_id, 137);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }


    public function delete_questioning(NamazegQuestioning $NamazegQuestioning)
    {
        $this->ManagerlogActivity('NamazegQuestioning', 'delete', $NamazegQuestioning->school_id, 137);
        $NamazegQuestioning->delete();

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //ٍسجلات
    // داخلى
    public function get_records($school_id, Request $request)
    {
        $current_school_year = School::findOrFail($school_id)->current_school_year;
        $class = ClassName::findOrFail($request->class_id);
        $semester = SchoolSemester::findOrFail($request->semester_id)->name;
        $school_class = SchoolClass::findOrFail($request->school_class_id)->className->name;
        $employee = SchoolEmployee::findOrFail($request->employee_id)->name;
        $subject = Subject::findOrFail($request->subject_id)->name;
        $students = Student::where('class_id', $request->school_class_id)->pluck('name')->toArray();

        return response()->json([
            'current_year' => $current_school_year,
            'school_class' => $school_class,
            'semester' => $semester,
            'subject' => $subject,
            'employee' => $employee,
            'students' => $students,
        ]);
    }

    //-----------------------------------------------------------
    //studentThing
    //144 نموذج الالتزام المدرس
    // داخلى
    public function get_school_commitment(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $committments = NamazegSchoolCommitment::with('student')->where('school_id', $school_id)->paginate($perPage);
        $committments_resource = SchoolCommitmentResource::collection($committments);

        return response()->json([
            'data' => $committments_resource
        ]);
    }
    public function store_school_commitment(SchoolCommittmentStoreRequest $request, $school_id)
    {
        $namozeg = Namazeg::where('form_number', '144')->first();
        $current_year = substr(Hijri::Date('Y'), -2); // Hijri year, last 2 digits
        $version = 1;
        $base_serial_number = $current_year . '-' . $namozeg->id . '-';
        $students = [];
        switch ($request->type) {
            case "student":
                $students = [$request->type_value];
                break;
            case "many_student":
                $students = $request->type_value;
                break;
            case "school_class":
            case "class":
                $students = Student::where('class_id', $request->type_value)->pluck('id')->toArray();
                break;
            case "all_student":
                Student::where('school_id', $school_id)->chunk(500, function ($studentChunk) use ($base_serial_number, &$version, $namozeg, $school_id) {
                    foreach ($studentChunk as $student) {
                        // Generate unique serial number directly for internal namozeg
                        do {
                            $new_serial_number = $base_serial_number . $version;
                            $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                            if ($serial_number) {
                                $version++;
                            }
                        } while ($serial_number);

                        // Store NamazegVersion
                        $namozeg_version = NamazegVersion::create([
                            'namazeg_id' => $namozeg->id,
                            'school_id' => $school_id,
                            'serial_number' => $new_serial_number,
                        ]);

                        // Store NamazegSchoolCommitment
                        NamazegSchoolCommitment::create([
                            'namazeg_version_id' => $namozeg_version->id,
                            'school_id' => $school_id,
                            'student_id' => $student->id
                        ]);
                    }
                });
                break;
            default:
                return response()->json([
                    'message' => trans('api.invalid type')
                ], 400);
        }

        if (!empty($students)) {
            foreach ($students as $student_id) {
                // Generate unique serial number directly for internal namozeg
                do {
                    $new_serial_number = $base_serial_number . $version;
                    $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                    if ($serial_number) {
                        $version++;
                    }
                } while ($serial_number);

                // Store NamazegVersion
                $namozeg_version = NamazegVersion::create([
                    'namazeg_id' => $namozeg->id,
                    'school_id' => $school_id,
                    'serial_number' => $new_serial_number,
                ]);

                // Store NamazegSchoolCommitment
                NamazegSchoolCommitment::create([
                    'namazeg_version_id' => $namozeg_version->id,
                    'school_id' => $school_id,
                    'student_id' => $student_id
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegSchoolCommitment', 'store', $school_id, 144);


        return response()->json([
            'message' => trans('api.record stored successfully')
        ]);
    }

    public function delete_school_commitment(NamazegSchoolCommitment $NamazegSchoolCommitment)
    {
        $NamazegSchoolCommitment->delete();
        $this->ManagerlogActivity('NamazegSchoolCommitment', 'delete', $NamazegSchoolCommitment->school_id, 144);

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //186 الخطة العامة لأنشطة حصص الاتقان للعام الدراسي
    // داخلى
    public function get_ClassPlanActivity(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $planActivity = NamazegClassPlanActivity::with('namozegVersion')->where('school_id', $school_id)->paginate($perPage);
        $planActivity_resource = PlanActivityResource::collection($planActivity);

        return response()->json([
            'data' => $planActivity_resource
        ]);
    }
    public function store_ClassPlanActivity(ClassPlanActivityStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '186')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegClassPlanActivity::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'n_classes' => $request->n_classes,
            'emplyee_ids' => $request->employee_ids,
            'specializations_ids' => $request->specializations_ids,
        ]);
        $this->ManagerlogActivity('NamazegClassPlanActivity', 'store', $school_id, 186);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_ClassPlanActivity(Request $request, NamazegClassPlanActivity $NamazegClassPlanActivity)
    {
        $NamazegClassPlanActivity->update([
            'n_classes' => $request->n_classes,
            'emplyee_ids' => $request->employee_ids,
            'specializations_ids' => $request->specializations_ids,
        ]);
        $this->ManagerlogActivity('NamazegClassPlanActivity', 'update', $NamazegClassPlanActivity->school_id, 186);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }

    public function delete_ClassPlanActivity(NamazegClassPlanActivity $ClassPlanActivity)
    {
        $this->ManagerlogActivity('NamazegClassPlanActivity', 'delete', $ClassPlanActivity->school_id, 186);
        $ClassPlanActivity->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    // 188  التقرير الختامي لحصص الاتقان للعام الدراسي
    // داخلى
    public function get_ReportClassPlanActivity(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $reportplanActivity = NamazegFinalReportClassActivity::with('namozegVersion')->where('school_id', $school_id)->paginate($perPage);
        $reportplanActivity_resource = ReportPlanActivityResource::collection($reportplanActivity);

        return response()->json([
            'data' => $reportplanActivity_resource
        ]);
    }


    public function store_ReportClassPlanActivity(ReportClassPlanActivityStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '188')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        NamazegFinalReportClassActivity::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'n_medical_sessions' => $request->n_medical_sessions,
            'percent_medical_sessions' => $request->percent_medical_sessions,
            'n_ernrichment_sessions' => $request->n_ernrichment_sessions,
            'percent_ernrichment_sessions' => $request->percent_ernrichment_sessions,
            'employee_ids' => $request->employee_ids,
            'difficulty' => $request->difficulty,
            'challenges' => $request->challenges,
            'solutions' => $request->solutions,
            'suggestions' => $request->suggestions,
            'date' => $date,
        ]);
        $this->ManagerlogActivity('NamazegFinalReportClassActivity', 'store', $school_id, 188);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_ReportClassPlanActivity(Request $request, NamazegFinalReportClassActivity $NamazegFinalReportClassActivity)
    {
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $NamazegFinalReportClassActivity->update([
            'n_medical_sessions' => $request->n_medical_sessions,
            'percent_medical_sessions' => $request->percent_medical_sessions,
            'n_ernrichment_sessions' => $request->n_ernrichment_sessions,
            'percent_ernrichment_sessions' => $request->percent_ernrichment_sessions,
            'employee_ids' => $request->employee_ids,
            'difficulty' => $request->difficulty,
            'challenges' => $request->challenges,
            'solutions' => $request->solutions,
            'suggestions' => $request->suggestions,
            'date' => $date,
        ]);
        $this->ManagerlogActivity('NamazegFinalReportClassActivity', 'update', $NamazegFinalReportClassActivity->school_id, 188);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_ReportClassPlanActivity(NamazegFinalReportClassActivity $FinalReportClassActivity)
    {
        $this->ManagerlogActivity('NamazegFinalReportClassActivity', 'delete', $FinalReportClassActivity->school_id, 188);
        $FinalReportClassActivity->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //158   قبول طالبة
    // داخلى
    public function get_accept_student(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $accept_student = NamazegAcceptStudent::with('namozegVersion', 'class')->where('school_id', $school_id)->paginate($perPage);
        $accept_student_resource = AcceptStudentResource::collection($accept_student);

        return response()->json([
            'data' => $accept_student_resource
        ]);
    }


    public function store_accept_student(AcceptStudentStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '158')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegAcceptStudent::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'student_name' => $request->student_name,
            'nationality' => $request->nationality,
            'ssn' => $request->ssn,
            'class_id' => $request->class_id,
            'from_school_manager' => $request->from_school_manager
        ]);
        $this->ManagerlogActivity('NamazegAcceptStudent', 'store', $school_id, 158);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }


    public function update_accept_student(Request $request, NamazegAcceptStudent $NamazegAcceptStudent)
    {

        $NamazegAcceptStudent->update([
            'student_name' => $request->student_name,
            'nationality' => $request->nationality,
            'ssn' => $request->ssn,
            'class_id' => $request->class_id,
            'from_school_manager' => $request->from_school_manager
        ]);
        $this->ManagerlogActivity('NamazegAcceptStudent', 'update', $NamazegAcceptStudent->school_id, 158);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }

    public function delete_accept_student(NamazegAcceptStudent $NamazegAcceptStudent)
    {
        $this->ManagerlogActivity('NamazegAcceptStudent', 'delete', $NamazegAcceptStudent->school_id, 158);
        $NamazegAcceptStudent->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    //190   طلب تحويل من مدارس تحفيظ القرآن الكريم والمعاهد العلمية للتعليم العام
    // داخلى
    public function get_transform_quran_student(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $accept_transform_student = NamazegTransformQuranStudent::with('namozegVersion', 'student')->where('school_id', $school_id)->paginate($perPage);
        $accept_transform_student_resource = TransferQuranResource::collection($accept_transform_student);

        return response()->json([
            'data' => $accept_transform_student_resource
        ]);
    }


    public function store_transform_quran_student(TransformQuroanStudentStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '190')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $birth_date = $request->birth_date_type == 'hijri' ? Helper::getCoptic($request->birth_date) : $request->birth_date;
        $certificate_date = $request->certificate_date_type == 'hijri' ? Helper::getCoptic($request->certificate_date) : $request->certificate_date;
        $form_department_date = $request->form_department_date_type == 'hijri' ? Helper::getCoptic($request->form_department_date) : $request->form_department_date;

        NamazegTransformQuranStudent::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'student_name' => $request->student_name,
            'birth_date' => $birth_date,
            'certificate_date' => $certificate_date,
            'last_certificate' => $request->last_certificate,
            'certificate_source' => $request->certificate_source,
            'trans_form' => $request->trans_form,
            'trans_to' => $request->trans_to,
            'study_type' => $request->study_type,

            'n_faild_years' => $request->n_faild_years,
            'faild_subjects' => $request->faild_subjects,
            'n_stoped_years' => $request->n_stoped_years,
            'stoped_reasons' => $request->stoped_reasons,
            'form_department_number' => $request->form_department_number,
            'form_department_date' => $form_department_date,
            'degrees' => $request->degrees,


        ]);
        $this->ManagerlogActivity('NamazegTransformQuranStudent', 'store', $school_id, 190);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_transform_quran_student(TransformQuroanStudentStoreRequest $request, $namozeg_data_id)
    {
        $namozeg_date = NamazegTransformQuranStudent::findOrFail($namozeg_data_id);
        $birth_date = $request->birth_date_type == 'hijri' ? Helper::getCoptic($request->birth_date) : $request->birth_date;
        $certificate_date = $request->certificate_date_type == 'hijri' ? Helper::getCoptic($request->certificate_date) : $request->certificate_date;
        $form_department_date = $request->form_department_date_type == 'hijri' ? Helper::getCoptic($request->form_department_date) : $request->form_department_date;

        $namozeg_date->update([
            'student_name' => $request->student_name,
            'birth_date' => $birth_date,
            'certificate_date' => $certificate_date,
            'last_certificate' => $request->last_certificate,
            'certificate_source' => $request->certificate_source,
            'trans_form' => $request->trans_form,
            'trans_to' => $request->trans_to,
            'study_type' => $request->study_type,
            'n_faild_years' => $request->n_faild_years,
            'faild_subjects' => $request->faild_subjects,
            'n_stoped_years' => $request->n_stoped_years,
            'stoped_reasons' => $request->stoped_reasons,
            'form_department_number' => $request->form_department_number,
            'form_department_date' => $form_department_date,
            'degrees' => $request->degrees,
        ]);
        $this->ManagerlogActivity('NamazegTransformQuranStudent', 'update', $namozeg_date->school_id, 190);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }


    public function delete_transform_quran_student(NamazegTransformQuranStudent $TransformQuranStudent)
    {
        $this->ManagerlogActivity('NamazegTransformQuranStudent', 'delete', $TransformQuranStudent->school_id, 190);
        $TransformQuranStudent->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    //191استمارة البيانات الشخصية للطالبة
    // داخلى
    public function get_student_data(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student_data_student = NamazegStudentData::with('namozegVersion', 'student')->where('school_id', $school_id)->paginate($perPage);
        $student_data_student_resource = SchoolCommitmentResource::collection($student_data_student);

        return response()->json([
            'data' => $student_data_student_resource
        ]);
    }


    public function store_student_data(StudentDataStoreRequest $request, $school_id)
    {
        $namozeg = Namazeg::where('form_number', '191')->first();
        $current_year = substr(Hijri::Date('Y'), -2); // Hijri year, last 2 digits
        $version = 1;
        $base_serial_number = $current_year . '-' . $namozeg->id . '-';
        $students = [];

        switch ($request->type) {
            case "student":
                $students = [$request->type_value];
                break;
            case "many_student":
                $students = $request->type_value;
                break;
            case "school_class":
            case "class":
                $students = Student::where('class_id', $request->type_value)->pluck('id')->toArray();
                break;
            case "all_student":
                Student::where('school_id', $school_id)->chunk(500, function ($studentChunk) use ($base_serial_number, &$version, $namozeg, $school_id) {
                    foreach ($studentChunk as $student) {
                        // Generate unique serial number directly for internal namozeg
                        do {
                            $new_serial_number = $base_serial_number . $version;
                            $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                            if ($serial_number) {
                                $version++;
                            }
                        } while ($serial_number);

                        // Store NamazegVersion
                        $namozeg_version = NamazegVersion::create([
                            'namazeg_id' => $namozeg->id,
                            'school_id' => $school_id,
                            'serial_number' => $new_serial_number,
                        ]);

                        // Store NamazegStudentData
                        NamazegStudentData::create([
                            'namazeg_version_id' => $namozeg_version->id,
                            'school_id' => $school_id,
                            'student_id' => $student->id
                        ]);
                    }
                });
                break;
            default:
                return response()->json([
                    'message' => trans('api.invalid type')
                ], 400);
        }

        if (!empty($students)) {
            foreach ($students as $student_id) {
                // Generate unique serial number directly for internal namozeg
                do {
                    $new_serial_number = $base_serial_number . $version;
                    $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                    if ($serial_number) {
                        $version++;
                    }
                } while ($serial_number);

                // Store NamazegVersion
                $namozeg_version = NamazegVersion::create([
                    'namazeg_id' => $namozeg->id,
                    'school_id' => $school_id,
                    'serial_number' => $new_serial_number,
                ]);

                // Store NamazegStudentData
                NamazegStudentData::create([
                    'namazeg_version_id' => $namozeg_version->id,
                    'school_id' => $school_id,
                    'student_id' => $student_id
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegStudentData', 'store', $school_id, 191);

        return response()->json([
            'message' => trans('api.record stored successfully')
        ]);
    }


    public function delete_student_data(NamazegStudentData $NamazegStudentData)
    {
        $this->ManagerlogActivity('NamazegStudentData', 'delete', $NamazegStudentData->school_id, 191);
        $NamazegStudentData->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    // 192  كشف تسليم الكتب المقررة 
    // داخلى
    public function get_books_delivery(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student_data_student = NamazegBooksDelivery::with('namozegVersion', 'class')->where('school_id', $school_id)->paginate($perPage);
        $student_data_student_resource = BookDeliveryResource::collection($student_data_student);

        return response()->json([
            'data' => $student_data_student_resource
        ]);
    }

    // per school_class
    public function store_books_delivery(BooksDeliveryStoreRequest $request, $school_id)
    {
        $namozeg = Namazeg::where('form_number', '192')->first();
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $current_year = substr(Hijri::Date('Y'), -2); // Hijri year, last 2 digits
        $version = 1;
        $base_serial_number = $current_year . '-' . $namozeg->id . '-';
        $class_ids = [];

        switch ($request->type) {
            case "school_class_id":
                $class_ids = SchoolClass::where('id', $request->type_value)->pluck('id')->toArray();
                break;
            case "class_id":
                $class_ids = SchoolClass::where('class_name_id', $request->type_value)
                    ->where('school_id', $school_id)
                    ->pluck('id')
                    ->toArray();
                break;
            case "all_classes":
                SchoolClass::where('school_id', $school_id)->chunk(500, function ($classChunk) use ($base_serial_number, &$version, $namozeg, $school_id, $date) {
                    foreach ($classChunk as $class) {
                        // Generate unique serial number directly for internal namozeg
                        do {
                            $new_serial_number = $base_serial_number . $version;
                            $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                            if ($serial_number) {
                                $version++;
                            }
                        } while ($serial_number);

                        // Store NamazegVersion
                        $namozeg_version = NamazegVersion::create([
                            'namazeg_id' => $namozeg->id,
                            'school_id' => $school_id,
                            'serial_number' => $new_serial_number,
                        ]);

                        // Store NamazegBooksDelivery
                        NamazegBooksDelivery::create([
                            'namazeg_version_id' => $namozeg_version->id,
                            'school_id' => $school_id,
                            'class_id' => $class->id,
                            'date' => $date
                        ]);
                    }
                });
                break;
            default:
                return response()->json([
                    'message' => trans('api.invalid type')
                ], 400);
        }

        if (!empty($class_ids)) {
            foreach ($class_ids as $class_id) {
                // Generate unique serial number directly for internal namozeg
                do {
                    $new_serial_number = $base_serial_number . $version;
                    $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                    if ($serial_number) {
                        $version++;
                    }
                } while ($serial_number);

                // Store NamazegVersion
                $namozeg_version = NamazegVersion::create([
                    'namazeg_id' => $namozeg->id,
                    'school_id' => $school_id,
                    'serial_number' => $new_serial_number,
                ]);

                // Store NamazegBooksDelivery
                NamazegBooksDelivery::create([
                    'namazeg_version_id' => $namozeg_version->id,
                    'school_id' => $school_id,
                    'class_id' => $class_id,
                    'date' => $date
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegBooksDelivery', 'store', $school_id, 192);
        return response()->json([
            'message' => trans('api.record stored successfully')
        ]);
    }


    public function delete_books_delivery(NamazegBooksDelivery $NamazegBooksDelivery)
    {
        $this->ManagerlogActivity('NamazegBooksDelivery', 'delete', $NamazegBooksDelivery->school_id, 192);
        $NamazegBooksDelivery->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    //224   إجراءات المتابعة على مستوى المدرسة لحالة طالب 
    // داخلى
    public function get_student_follow(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student_data_student = NamazegStudentFollow::with('namozegVersion', 'student')->where('school_id', $school_id)->paginate($perPage);
        $student_data_student_resource = FollowStudentResource::collection($student_data_student);

        return response()->json([
            'data' => $student_data_student_resource
        ]);
    }

    public function store_student_follow(StudentFollowStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '224')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegStudentFollow::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'student_id' => $request->student_id
        ]);
        $this->ManagerlogActivity('NamazegStudentFollow', 'store', $school_id, 224);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_student_follow(StudentFollowStoreRequest $request, NamazegStudentFollow $NamazegStudentFollow)
    {
        $NamazegStudentFollow->update(
            [
                'student_id' => $request->student_id
            ]
        );
        $this->ManagerlogActivity('NamazegStudentFollow', 'update', $NamazegStudentFollow->school_id, 224);
        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_student_follow(NamazegStudentFollow $NamazegStudentFollow)
    {
        $this->ManagerlogActivity('NamazegStudentFollow', 'delete', $NamazegStudentFollow->school_id, 224);
        $NamazegStudentFollow->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //-----------------------------------------------------------
    //schoolThing
    // 168 سجل استئذان الموظفة أثناء الدوام
    // داخلى
    public function get_teacher_excuse(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student_data_student = NamazegEmployeeLeavingRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $student_data_student_resource = EmployeeLeavingRecordResource::collection($student_data_student);

        return response()->json([
            'data' => $student_data_student_resource
        ]);
    }

    public function store_teacher_excuse(EmployeeLeavingRecordStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '168')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        foreach ($request->employee_ids as $employee_id) {
            NamazegEmployeeLeavingRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id
            ]);
        }
        $this->ManagerlogActivity('NamazegEmployeeLeavingRecord', 'store',  $school_id, 168);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_teacher_excuse(NamazegEmployeeLeavingRecord $teacher_excuse)
    {
        $this->ManagerlogActivity('NamazegEmployeeLeavingRecord', 'delete',  $teacher_excuse->school_id, 168);
        $teacher_excuse->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    // 169 مساءلة غياب
    // داخلى
    public function get_absence_questioning(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student_data_student = NamazegAbsenceQuestioning::with('namozegVersion', 'employee', 'action')->where('school_id', $school_id)->paginate($perPage);
        $student_data_student_resource = AbsenceQuestioningResource::collection($student_data_student);

        return response()->json([
            'data' => $student_data_student_resource
        ]);
    }

    public function store_absence_questioning(AbsenceQuestioningStoreRequest $request, $school_id)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        $namozeg = Namazeg::where('form_number', '169')->first();
        $absence_date = $request->absence_date_type == 'hijri' ? Helper::getCoptic($request->absence_date) : $request->absence_date;
        $attendance_date = $request->attendance_date_type == 'hijri' ? Helper::getCoptic($request->attendance_date) : $request->attendance_date;

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegAbsenceQuestioning::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'employee_id' => $request->employee_id,
            'user_id' => $user->id,
            'absence_date' => $absence_date,
            'attendance_date' => $attendance_date,
            'date' => $request->date
        ]);
        $this->ManagerlogActivity('NamazegAbsenceQuestioning', 'store',  $school_id, 169);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_absence_questioning(AbsenceQuestioningStoreRequest $request, NamazegAbsenceQuestioning $absence_questioning)
    {

        $absence_date = $request->absence_date_type == 'hijri' ? Helper::getCoptic($request->absence_date) : $request->absence_date;
        $attendance_date = $request->attendance_date_type == 'hijri' ? Helper::getCoptic($request->absence_date) : $request->absence_date;

        $absence_questioning->update([
            'employee_id' => $request->employee_id,
            'absence_date' => $absence_date,
            'attendance_date' => $attendance_date,
            'date' => $request->date
        ]);
        $this->ManagerlogActivity('NamazegAbsenceQuestioning', 'update',  $absence_questioning->school_id, 169);
        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }

    public function action_absence_questioning(NamazegAbsenceQuestioning $absence_questioning, Request $request)
    {

        if ($request->option_id == 2) {
            $check_five = NamazegAbsenceQuestioning::whereHas('action', function ($query) {
                $query->where('absence_questioning_option_id', 2);
            })->count();

            if ($check_five == 5) {
                return response()->json([
                    'message' => trans('لا يمكن تنفيذ هذا الاجراء لهذا المعلم لانك قمت به حتى الان 5 مرات.'),
                ], 422);
            }
        }

        $absence_questioning_action = AbsenceQuestioningAction::updateOrCreate(
            ['absence_questioning_id' => $absence_questioning->id],
            [
                'serial_number' => $absence_questioning->namozegVersion->serial_number,
                'absence_questioning_option_id' => $request->option_id,
                'report_type' => $request->report_type,
                'n_days' => $request->n_days,
            ]
        );
        if ($absence_questioning_action->descion_confirm && $request->option_id != 3) {
            NamazegAbsenceDescionConfirm::find($absence_questioning_action->absence_descion_confirm_id)->delete();
        }
        if ($request->option_id == 3) {
            $special_request = new AbsenceDescionConfirmStoreRequest;
            $special_request['n_days'] = $request->n_days;
            $special_request['employee_id'] = $absence_questioning->employee_id;
            if ($absence_questioning_action->descion_confirm) {
                $absence_descion_confirm_response = $this->update_absence_descion_confirm($special_request, $absence_questioning_action->descion_confirm);
                $absence_descion_confirm_id = $absence_descion_confirm_response->getData()->absence_descion_confirm_id;
            } else {
                $absence_descion_confirm_response = $this->store_absence_descion_confirm($special_request, $absence_questioning->employee->school_id);
                $absence_descion_confirm_id = $absence_descion_confirm_response->getData()->absence_descion_confirm_id;
            }
            $absence_questioning_action->update(['absence_descion_confirm_id' => $absence_descion_confirm_id]);
        }

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    public function delete_absence_questioning(NamazegAbsenceQuestioning $absence_questioning)
    {
        if ($absence_questioning->action) {
            if ($absence_questioning->action->absence_descion_confirm_id) {
                NamazegAbsenceDescionConfirm::find($absence_questioning->action->absence_descion_confirm_id)->delete();
            }
            AbsenceQuestioningAction::where('absence_questioning_id', $absence_questioning->id)->delete();
        }

        $this->ManagerlogActivity('NamazegAbsenceQuestioning', 'delete',  $absence_questioning->school_id, 169);
        $absence_questioning->delete();

        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //قرار حسم غياب 170
    // داخلى
    public function get_absence_descion_confirm(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegAbsenceDescionConfirm::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = AbsenceDescionConfirmResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_absence_descion_confirm(AbsenceDescionConfirmStoreRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '170')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $absence_descion_confirm = NamazegAbsenceDescionConfirm::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'employee_id' => $request->employee_id,
            'n_days' => $request->n_days
        ]);
        $this->ManagerlogActivity('NamazegAbsenceDescionConfirm', 'store',  $school_id, 170);
        return response()->json([
            'message' => trans('api.record stored successflly'),
            'absence_descion_confirm_id' => $absence_descion_confirm->id
        ]);
    }
    public function update_absence_descion_confirm(AbsenceDescionConfirmStoreRequest $request, NamazegAbsenceDescionConfirm $NamazegAbsenceDescionConfirm)
    {
        $NamazegAbsenceDescionConfirm->update([
            'employee_id' => $request->employee_id,
            'n_days' => $request->n_days
        ]);
        if ($NamazegAbsenceDescionConfirm->descion_action) {
            AbsenceQuestioningAction::where('absence_descion_confirm_id', $NamazegAbsenceDescionConfirm->id)
                ->update(['n_days' => $request->n_days]);
        }
        $this->ManagerlogActivity('NamazegAbsenceDescionConfirm', 'update',  $NamazegAbsenceDescionConfirm->school_id, 170);
        return response()->json([
            'message' => trans('api.record updated successflly'),
            'absence_descion_confirm_id' => $NamazegAbsenceDescionConfirm->id
        ]);
    }

    public function delete_absence_descion_confirm(NamazegAbsenceDescionConfirm $absence_descion_confirm)
    {
        $this->ManagerlogActivity('NamazegAbsenceDescionConfirm', 'delete',  $absence_descion_confirm->school_id, 170);
        $absence_descion_confirm->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //تنبيه عن تأخر / انصراف 171
    // داخلى
    public function get_notify_late_leaving(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegNotifyLateLeaving::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = NotifyLateLeavingResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_notify_late_leaving(NotifyLateLeavingRequest $request, $school_id)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        $namozeg = Namazeg::where('form_number', '171')->first();

        $start_date = $request->start_date;
        $end_date = $request->end_date;

        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegNotifyLateLeaving::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'user_id' => $user->id,
            'employee_id' => $request->employee_id,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'date' => $date,
            'level' => $request->level,
            'type' => $request->type,
        ]);
        $this->ManagerlogActivity('NamazegNotifyLateLeaving', 'store',  $school_id, 171);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }

    public function update_notify_late_leaving(NotifyLateLeavingRequest $request, NamazegNotifyLateLeaving $NamazegNotifyLateLeaving)
    {

        $start_date = $request->start_date;
        $end_date = $request->end_date;


        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $NamazegNotifyLateLeaving->update([
            'employee_id' => $request->employee_id,
            'start_date' => $start_date,
            'end_date' => $end_date,
            'date' => $date,
            'level' => $request->level,
            'type' => $request->type,
        ]);
        $this->ManagerlogActivity('NamazegNotifyLateLeaving', 'update',  $NamazegNotifyLateLeaving->school_id, 171);
        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }

    public function delete_notify_late_leaving(NamazegNotifyLateLeaving $notify_late_leaving)
    {
        $this->ManagerlogActivity('NamazegNotifyLateLeaving', 'delete',  $notify_late_leaving->school_id, 171);
        $notify_late_leaving->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //قرار حسم مجموع ساعات تأخر و خروج مبكر 172
    // داخلى
    public function get_descion_sum_hours(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegDescionSumhoursLateleaving::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = DescionSumHoursResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_descion_sum_hours(DescionSumHoursRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '172')->first();

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegDescionSumhoursLateleaving::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'employee_id' => $request->employee_id,
            'n_days' => $request->n_days,
            'n_hours' => $request->n_hours,
        ]);
        $this->ManagerlogActivity('NamazegDescionSumhoursLateleaving', 'store',  $school_id, 172);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_descion_sum_hours(DescionSumHoursRequest $request, NamazegDescionSumhoursLateleaving $DescionSumhoursLateleaving)
    {

        $DescionSumhoursLateleaving->update([
            'employee_id' => $request->employee_id,
            'n_days' => $request->n_days,
            'n_hours' => $request->n_hours,
        ]);
        $this->ManagerlogActivity('NamazegDescionSumhoursLateleaving', 'update',  $DescionSumhoursLateleaving->school_id, 172);
        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }


    public function delete_descion_sum_hours(NamazegDescionSumhoursLateleaving $descion_sum_hours)
    {
        $this->ManagerlogActivity('NamazegDescionSumhoursLateleaving', 'delete',  $descion_sum_hours->school_id, 172);
        $descion_sum_hours->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //رصد غياب و تأخر المعلمات 177
    // داخلى
    public function get_monitoring_absence_teacher(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegMonitoringLateAbsenceTeacher::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_monitoring_absence_teacher(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '177')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegMonitoringLateAbsenceTeacher::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegMonitoringLateAbsenceTeacher', 'store',  $school_id, 177);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }

    public function delete_monitoring_absence_teacher(NamazegMonitoringLateAbsenceTeacher $monitoring_absence_teacher)
    {
        $this->ManagerlogActivity('NamazegMonitoringLateAbsenceTeacher', 'delete',  $monitoring_absence_teacher->school_id, 177);
        $monitoring_absence_teacher->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //سجل جرد المعامل 164
    // داخلى
    public function get_labInventory_record(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegLabInventoryRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);
        return response()->json(['data' => $employee_absence_resource]);
    }

    public function store_labInventory_record(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '164')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegLabInventoryRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegLabInventoryRecord', 'store',  $school_id, 164);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }

    public function delete_labInventory_record(NamazegLabInventoryRecord $labInventory_record)
    {
        $this->ManagerlogActivity('NamazegLabInventoryRecord', 'delete',  $labInventory_record->school_id, 164);
        $labInventory_record->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    // سجل تنفيذ التجارب العلمية 166
    // داخلى
    public function get_experment_excution_record(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegExpermentExcutionRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_experment_excution_record(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '166')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegExpermentExcutionRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegExpermentExcutionRecord', 'store',  $school_id, 166);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_experment_excution_record(NamazegExpermentExcutionRecord $experment_excution_record)
    {
        $this->ManagerlogActivity('NamazegExpermentExcutionRecord', 'delete',  $experment_excution_record->school_id, 166);
        $experment_excution_record->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    // سجل جرد المختبر و المواد الكيميائية 179
    // داخلى
    public function get_chemist_labInventory_record(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegChemistLabInventoryRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_chemist_labInventory_record(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '179')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegChemistLabInventoryRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegChemistLabInventoryRecord', 'store',  $school_id, 179);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_chemist_labInventory_record(NamazegChemistLabInventoryRecord $chemist_labInventory_record)
    {
        $this->ManagerlogActivity('NamazegChemistLabInventoryRecord', 'delete',  $chemist_labInventory_record->school_id, 179);
        $chemist_labInventory_record->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //  18سجل الزائد و الناقص و التالف0 
    // داخلى
    public function get_excessDamage_record(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegExcessDamageRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_excessDamage_record(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '180')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegExcessDamageRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegExcessDamageRecord', 'store',  $school_id, 180);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }

    public function delete_excessDamage_record(NamazegExcessDamageRecord $excessDamage_record)
    {
        $this->ManagerlogActivity('NamazegExcessDamageRecord', 'delete',  $excessDamage_record->school_id, 180);
        $excessDamage_record->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //  163 سجل استلام عهدة
    // داخلى
    public function get_reciept_record(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_absence = NamazegRecieptRecord::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_absence_resource = MoniteringLateTeacherResource::collection($employee_absence);

        return response()->json([
            'data' => $employee_absence_resource
        ]);
    }

    public function store_reciept_record(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '163')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegRecieptRecord::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegRecieptRecord', 'store',  $school_id, 163);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_reciept_record(NamazegRecieptRecord $reciept_record)
    {
        $this->ManagerlogActivity('NamazegRecieptRecord', 'delete',  $reciept_record->school_id, 163);
        $reciept_record->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    //  167 استمارة موافقة ولي أمر الطالبة للاشتراك في النقل المدرسي
    // داخلى
    public function get_guardian_trans_from(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $student = NamazegGuardianTransFrom::with('namozegVersion', 'student')->where('school_id', $school_id)->paginate($perPage);
        $student_resource = GuardianTransFromRequestResource::collection($student);

        return response()->json([
            'data' => $student_resource
        ]);
    }

    public function store_guardian_trans_from(GuardianTransFromRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '167')->first();
        $current_year = substr(Hijri::Date('Y'), -2);
        $version = 1;
        $base_serial_number = $current_year . '-' . $namozeg->id . '-';
        $studentChunks = array_chunk($request->students_ids, 50);

        foreach ($studentChunks as $studentChunk) {
            foreach ($studentChunk as $student_id) {
                do {
                    $new_serial_number = $base_serial_number . $version;
                    $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                    if ($serial_number) {
                        $version++;
                    }
                } while ($serial_number);

                $namozeg_version = NamazegVersion::create([
                    'namazeg_id' => $namozeg->id,
                    'school_id' => $school_id,
                    'serial_number' => $new_serial_number,
                ]);

                NamazegGuardianTransFrom::create([
                    'namazeg_version_id' => $namozeg_version->id,
                    'school_id' => $school_id,
                    'student_id' => $student_id,
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegGuardianTransFrom', 'store',  $school_id, 167);

        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_guardian_trans_from(NamazegGuardianTransFrom $guardian_trans_from)
    {
        $this->ManagerlogActivity('NamazegGuardianTransFrom', 'delete',  $guardian_trans_from->school_id, 167);
        $guardian_trans_from->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //  165 الخطة الفصلية للتجارب العلمية
    // داخلى
    public function get_experments_plan(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $employee_experment_plan = NamazegExpermentsPlan::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $employee_experment_plan_resource = MoniteringLateTeacherResource::collection($employee_experment_plan);

        return response()->json([
            'data' => $employee_experment_plan_resource
        ]);
    }

    public function store_experments_plan(MoniteringLateTeacherRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '165')->first();
        foreach ($request->employee_ids as $employee_id) {
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school_id
            );
            NamazegExpermentsPlan::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school_id,
                'employee_id' => $employee_id,
            ]);
        }
        $this->ManagerlogActivity('NamazegExpermentsPlan', 'store',  $school_id, 165);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function delete_experments_plan(NamazegExpermentsPlan $experments_plan)
    {
        $this->ManagerlogActivity('NamazegExpermentsPlan', 'delete',  $experments_plan->school_id, 165);
        $experments_plan->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    //  162 طلب صيانة
    // داخلى
    public function get_maintenance_form(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $maintenance_plan = NamazegMaintenanceForm::with('namozegVersion')->where('school_id', $school_id)->paginate($perPage);
        $maintenance_plan_resource = MaintenanceFormResource::collection($maintenance_plan);

        return response()->json([
            'data' => $maintenance_plan_resource
        ]);
    }

    public function store_maintenance_form(MaintenanceFormRequest $request, $school_id)
    {

        $namozeg = Namazeg::where('form_number', '162')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        NamazegMaintenanceForm::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'is_urgent' => $request->is_urgent,
            'date_type_prefered' => $request->date_type_prefered,
            'maintenance_type' => $request->maintenance_type,
            'other_type' => $request->other_type,
            'maintenance_desc' => $request->maintenance_desc
        ]);
        $this->ManagerlogActivity('NamazegMaintenanceForm', 'store',  $school_id, 162);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_maintenance_form(MaintenanceFormRequest $request, NamazegMaintenanceForm $NamazegMaintenanceForm)
    {

        $NamazegMaintenanceForm->update([
            'is_urgent' => $request->is_urgent,
            'date_type_prefered' => $request->date_type_prefered,
            'maintenance_type' => $request->maintenance_type,
            'other_type' => $request->other_type,
            'maintenance_desc' => $request->maintenance_desc
        ]);
        $this->ManagerlogActivity('NamazegMaintenanceForm', 'update',  $NamazegMaintenanceForm->school_id, 162);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_maintenance_form(NamazegMaintenanceForm $maintenance_form)
    {
        $this->ManagerlogActivity('NamazegMaintenanceForm', 'delete',  $maintenance_form->school_id, 162);
        $maintenance_form->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //  189 قرير خطة الإخلاء
    // داخلى
    public function get_evacuation_planReport(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $evacuation_report = NamazegEvacuationPlanReport::with('namozegVersion', 'images')->where('school_id', $school_id)->paginate($perPage);
        $evacuation_report_resource = EvacuationimagesResource::collection($evacuation_report);

        return response()->json([
            'data' => $evacuation_report_resource
        ]);
    }

    public function store_evacuation_planReport(EvacuationRequest $request, $school_id)
    {
        $namozeg = Namazeg::where('form_number', '189')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $evacuation_plan = NamazegEvacuationPlanReport::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'time' => $request->time,
            'date' => $date,
            'n_employees' => $request->n_employees,
            'n_students' => $request->n_students,
            'safety_man' => $request->safety_man,
            'duration' => $request->duration,
        ]);
        if ($request->images) {
            foreach ($request->images as $image) {
                $image_name = Helper::uploadImage('evacuationNamozeg', $image);
                NamazegEvacuationPlanImages::create([
                    'namazeg_version_id' => $namozeg_version->id,
                    'school_id' => $school_id,
                    'namazeg_evacuation_id' => $evacuation_plan->id,
                    'image' => $image_name,
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegEvacuationPlanReport', 'store',  $school_id, 189);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_evacuation_planReport(EvacuationRequest $request, NamazegEvacuationPlanReport $EvacuationPlanReport)
    {

        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $EvacuationPlanReport->update([
            'time' => $request->time,
            'date' => $date,
            'n_employees' => $request->n_employees,
            'n_students' => $request->n_students,
            'safety_man' => $request->safety_man,
            'duration' => $request->duration,
        ]);
        if ($request->images) {
            foreach ($request->images as $image) {
                $image_name = Helper::uploadImage('evacuationNamozeg', $image);
                NamazegEvacuationPlanImages::create([
                    'namazeg_version_id' => $EvacuationPlanReport->namazeg_version_id,
                    'school_id' => $EvacuationPlanReport->school_id,
                    'namazeg_evacuation_id' => $EvacuationPlanReport->id,
                    'image' => $image_name,
                ]);
            }
        }
        $this->ManagerlogActivity('NamazegEvacuationPlanReport', 'update',  $EvacuationPlanReport->school_id, 189);

        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_image_evacuation_planReport(Request $request)
    {
        $image = NamazegEvacuationPlanImages::findOrFail($request->id);
        $path = public_path("uploads/evacuationNamozeg/$image->image");
        if (file_exists($path)) {
            unlink($path);
        }
        $image->delete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
    public function delete_evacuation_planReport(NamazegEvacuationPlanReport $evacuation_planReport)
    {
        $this->ManagerlogActivity('NamazegEvacuationPlanReport', 'delete',  $evacuation_planReport->school_id, 189);
        $evacuation_planReport->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    //  230 استئذان معلمة أثناء الدوام الرسمي
    // داخلى
    public function get_teacher_excuse_workday(Request $request, $school_id)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $evacuation_report = NamazegTeacherExcuse::with('namozegVersion', 'employee')->where('school_id', $school_id)->paginate($perPage);
        $evacuation_report_resource = MoniteringLateTeacherResource::collection($evacuation_report);

        return response()->json([
            'data' => $evacuation_report_resource
        ]);
    }

    public function store_teacher_excuse_workday(TeacherExcuseDayRequest $request, $school_id)
    {
        $namozeg = Namazeg::where('form_number', '230')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        NamazegTeacherExcuse::create([
            'namazeg_version_id' => $namozeg_version->id,
            'school_id' => $school_id,
            'date' => $date,
            'employee_id' => $request->employee_id,
        ]);
        $this->ManagerlogActivity('NamazegTeacherExcuse', 'store',  $school_id, 230);
        return response()->json([
            'message' => trans('api.record stored successflly')
        ]);
    }
    public function update_teacher_excuse_workday(TeacherExcuseDayRequest $request, NamazegTeacherExcuse $NamazegTeacherExcuse)
    {

        $date = $request->date_type == 'hijri' ? Helper::getCoptic($request->date) : $request->date;

        $NamazegTeacherExcuse->update([
            'date' => $date,
            'employee_id' => $request->employee_id,
        ]);
        $this->ManagerlogActivity('NamazegTeacherExcuse', 'update',  $NamazegTeacherExcuse->school_id, 230);
        return response()->json([
            'message' => trans('api.record updated successflly')
        ]);
    }
    public function delete_teacher_excuse_workday(NamazegTeacherExcuse $teacher_excuse_workday)
    {
        $this->ManagerlogActivity('NamazegTeacherExcuse', 'delete',  $teacher_excuse_workday->school_id, 230);
        $teacher_excuse_workday->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
}
