<?php

namespace App\Http\Controllers\Api\ManagerDashboard\ManagerLogs;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdminDashboard\Logs\LogResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;

class ManagerLogsController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:logs']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll($school_id)
    {
        // Start with the base query
        $data = Activity::with('causer')->orderBy('created_at','Desc')->whereJsonContains('properties->school_id', $school_id);
        // $data = Activity::with('causer')->orderBy('created_at','Desc')->where('created_at',today());  

        $filterData = LogResource::collection($data->take(50)->get());
        return response()->json([
            'manager_logs' => $filterData,
            'message' => 'manager_logs_data',
        ]);
    }

}
