<?php

namespace App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\StoreAlertRequest;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\UpdateAlertRequest;

use App\Http\Resources\ManagerDashboard\LetterAndAlart\AlertResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\AlertNote;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use App\Traits\SmsTrait;
use Illuminate\Http\Request;
use JWTAuth;

class AlertController extends Controller
{
    use LogsActivity, NamazegTrait, SmsTrait;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:Alert']);
    }
    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request, School $school)
    {

        $data = Alert::query()->with('notes')->where('school_id', $school->id);

        // Retrieve all query parameters
        $queryParams = $request->query();

        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\OfficialSpeeches\Alert', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = AlertResource::collection($data->paginate($perPage));


        return response()->json([
            'alerts' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAlertRequest $request, School $school)
    {
        $token = $request->bearerToken();
        // if($token){
        //     $user = JWTAuth::toUser($token);
        // }
        $validatedData = $request->validated();


        if ($validatedData['date_type'] === 'hijri') {
            $validatedData['date'] = Helper::getCoptic($validatedData['date']);
            $validatedData['date_type'] = 'coptic';
        }

        switch ($request->type) {
            case "written":
                $form_number = 39;
                $message_text = "تم اصدار تنبيه شفهى لكم.";
                break;
            case "verbal":
                $form_number = 40;
                $message_text = "تم اصدار تنبيه خطى لكم.";
                break;
            default:
        };

        $namozeg = Namazeg::where('form_number', $form_number)->first();

        $namozeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        )->id;

        $validatedData['namazeg_version_id'] = $namozeg_version_id;

        $validatedData['school_id'] = $school->id;

        $notes = $validatedData['notes'];

        unset($validatedData['notes']);

        // $validatedData['user_id'] = $user->id;

        /* get current semester from alert date*/
        $validatedData['semester_id'] = Helper::getCurrentSchoolSemester()->id;

        $alert = Alert::create($validatedData);

        foreach ($notes as $note) {
            $alertNote = new AlertNote();
            $alertNote->content = $note;
            $alert->notes()->save($alertNote);
        }
        $notification_setting = NotificationSchoolSetting::where('school_id', $school->id)
            ->where('notification_setting_id', 1)
            ->first();
        if ($notification_setting->messages) {
            $user = SchoolEmployee::where('id', $request->alert_direct_to)->first();
            static::sendSMSNotification($user->phone, $message_text, $user->manager_id);
        }


        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(School $school, Alert $alert)
    {
        $alert = new AlertResource($alert->load('notes'));
        return  response()->json(['alert' => $alert], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAlertRequest $request, School $school, Alert $alert)
    {

        $validatedData = $request->validated();

        if ($request->date_type) {
            if ($validatedData['date_type'] === 'hijri') {
                $validatedData['date'] = Helper::getCoptic($validatedData['date']);
                $validatedData['date_type'] = 'coptic';
            }
        }

        if (isset($validatedData['notes'])) {
            $notes = $validatedData['notes'];
            unset($validatedData['notes']);

            $alert->update($validatedData);

            $alert->notes()->forceDelete();

            foreach ($notes as $note) {
                $alertNote = new AlertNote();
                $alertNote->content = $note;
                $alert->notes()->save($alertNote);
            }
        } else {
            $alert->update($validatedData);
        }
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(School $school, Alert $alert)
    {

        $alert->delete();

        $alert->notes()->delete();

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, Alert $alert)
    {
        $alert->forceDelete();
        $alert->notes()->forceDelete();
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }

    /**
     * restore the specified resource from storage.
     */
    public function restore(School $school, Alert $alert)
    {
        $alert->restore();
        $alert->notes()->restore();
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
