<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\SupervisionCommittees;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignmentRequest;
use App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees\UpdateCorrectionAssignmentRequest;
use App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignmentResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignmentMember;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class CorrectionCommiteeController extends Controller
{
    use  NamazegTrait;

    public function getAllAssignments(School $school)
    {
        $assignments = CorrectionAssignmentResource::collection(CorrectionAssignment::with('members')->where('school_id', $school->id)->get());

        return response()->json(['assignments' => $assignments]);
    }


    public function store(CorrectionAssignmentRequest $request, School $school)
    {

        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 67)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }


        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        );

        $assignment = CorrectionAssignment::create(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'round' => $data['round'] ?? 'الأول',
                'subject_id' => $data['subject_id'],
                'location' => $data['location']
            ]
        );

        foreach ($data['members'] as $member) {
            CorrectionAssignmentMember::updateOrCreate([
                'assignment_id' =>  $assignment->id,
                'employee_id' => $member['employee_id'],
                'assignment_work' => $member['assignment_work'],
                'mission' => $member['mission'] ?? null,
            ]);
        }

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    public function updateAssignment(UpdateCorrectionAssignmentRequest $request, School $school, CorrectionAssignment $assignment)
    {
        $data = $request->validated();

        $members = $data['members'];

        unset($data['members']);
        
        $assignment->update($data);

        // Delete all members related to this assignment before adding new ones
        CorrectionAssignmentMember::where('assignment_id', $assignment->id)->delete();

        foreach ($members as $member) {
            CorrectionAssignmentMember::updateOrCreate([
                'assignment_id' =>  $assignment->id,
                'employee_id' => $member['employee_id'],
                'assignment_work' => $member['assignment_work'],
                'mission' => $member['mission'] ?? null,
            ]);
        }

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    public function deleteAssignment(School $school, CorrectionAssignment $assignment)
    {

        $assignment->delete();
        CorrectionAssignmentMember::where('assignment_id', $assignment->id)->delete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
