<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment\StoreAssignmentRequest;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment\UpdateAssignmentRequest;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignmentResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment as NamazegPlansTeacherQuestionAssignment;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignmentSubject;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TeacherQuestionAssignment extends Controller
{
    use NamazegTrait;
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, School $school)
    {

        // $queryParams = $request->query();
        // $perPage = $queryParams['per_page'] ?? 15;
        $assignment = NamazegPlansTeacherQuestionAssignment::with('namozegVersion', 'employee')->where('school_id', $school->id)->get();
        $assignment_resource = TeacherQuestionAssignmentResource::collection($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAssignmentRequest $request, School $school)
    {
        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 68)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        );

        $assignment =  NamazegPlansTeacherQuestionAssignment::create(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'teacher_id' => $data['teacher_id']
            ]
        );

        foreach ($data['data'] as $subject) {

            TeacherQuestionAssignmentSubject::create(
                [
                    'tqa_assignment_id' =>  $assignment->id,
                    'subject_id' => $subject['subject_id'],
                    'class_name_id'   => $subject['class_name_id'],
                ]
            );
        }

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Display the specified resource.
     */
    public function show(School $school, NamazegPlansTeacherQuestionAssignment $assignment)
    {
        $assignment_resource = new TeacherQuestionAssignmentResource($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAssignmentRequest $request,  School $school, NamazegPlansTeacherQuestionAssignment $assignment)
    {
        $data = $request->validated();

        if ($assignment->school_id !== $school->id) {
            return response()->json(['errors' => trans('لم يتم العثور علي هذا التكليف لهذه المدرسه')], 404);
        }

        DB::transaction(function () use ($assignment, $data) {

            $assignment->update(['teacher_id' => $data['teacher_id']]);

            TeacherQuestionAssignmentSubject::where('tqa_assignment_id', $assignment->id)->forceDelete();

            foreach ($data['data'] as $subject) {

                TeacherQuestionAssignmentSubject::create([
                    'tqa_assignment_id' => $assignment->id,
                    'subject_id' => $subject['subject_id'],
                    'class_name_id' => $subject['class_name_id'],
                ]);
            }
        });

        return response()->json(['message' => trans('api.record updated successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, NamazegPlansTeacherQuestionAssignment $assignment)
    {
        if ($assignment->school_id == $school->id) {
            $assignment->delete();
            TeacherQuestionAssignmentSubject::where('tqa_assignment_id', $assignment->id)->delete();
        }

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
