<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDailyObservers\StoreMonitorDailyObserverRequest;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDailyObservers\UpdateMonitorDailyObserverRequest;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\DailyObservesResource;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\MonitorDailyObserversResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers\DailyObserves;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistribtionAssignmentMonitor;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class DailyObservesController extends Controller
{
    use NamazegTrait;

    /**
     * Display a listing of the resource.
     */
    public function index(School $school)
    {

        $semesterMonitorDistrubution = SchoolSemester::with(['monitorDistribution' => function ($query) use ($school) {
            $query->where('school_id', $school->id);
        }])->get();
        
        $smester_resource = new DailyObservesResource($semesterMonitorDistrubution);

        return response()->json([
            $smester_resource
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMonitorDailyObserverRequest $request, School $school, DistribtionAssignmentMonitor $monitor)
    {

        $dataValidate = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 82)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }


        // Check if a NamazegVersion already exists for the school and namozeg_id
        $existing_version = NamazegVersion::where('namazeg_id', $namozeg->id)
            ->where('school_id', $school->id)
            ->first();

        if (!$existing_version) {
            // If no version exists, create a new one using the trait method
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school->id
            );
        } else {
            // Use the existing version
            $namozeg_version = $existing_version;
        }

        $dailyObserve = DailyObserves::updateOrCreate(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'monitor_id' => $monitor->id,
            ],
            [
                'committee_id' => $dataValidate['data']['committee_id'],
                // 'committee_location' => $dataValidate['data']['committee_location'],
                'subject_id' => $dataValidate['data']['subject_id'],
                'exam_time' => $dataValidate['data']['exam_time'],
                'employees_ids' => json_encode($dataValidate['data']['employees_ids']),
            ]
        );
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Display the specified resource.
     */
    public function show(School $school, DistribtionAssignmentMonitor $monitor)
    {
        $distribtionAssignmentMonitor = new MonitorDailyObserversResource($monitor);
        return response()->json([
            'data' => $distribtionAssignmentMonitor
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMonitorDailyObserverRequest $request, School $school, DistribtionAssignmentMonitor $monitor)
    {
        $dataValidate = $request->validated();

        $dailyObserve =   DailyObserves::where('monitor_id', $monitor->id)->firstOrfail();
        $dailyObserve->update([
            'committee_id' => $dataValidate['data']['committee_id'],
            // 'committee_location' => $dataValidate['data']['committee_location'],
            'subject_id' => $dataValidate['data']['subject_id'],
            'exam_time' => $dataValidate['data']['exam_time'],
            'employees_ids' => json_encode($dataValidate['data']['employees_ids']),
        ]);
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, DistribtionAssignmentMonitor $monitor)
    {
        $dailyObserve =   DailyObserves::where('monitor_id', $monitor->id)->firstOrfail();
        $dailyObserve->forceDelete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
