<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Circulars;

use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Circulars\InternalCircularRequest;
use App\Http\Resources\ManagerDashboard\Circulars\InternalCircularResource;
use App\Models\ManagerDashboard\Circulars\InternalCircular;
use Illuminate\Http\Request;
use App\Models\ManagerDashboard\Circulars\InternalCircularTeacher;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;

class InternalCircularController extends Controller
{
    use LogsActivity,NamazegTrait;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify','permission:internal_circulars']);
    }
    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = InternalCircular::query();

        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key,['date','date_type','per_page']);
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Circulars\InternalCircular', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        if (isset($queryParams['date_type']) && isset($queryParams['date'])) {
            $date = $queryParams['date'];
            if ($queryParams['date_type'] == "hijri") {
                $date = Helper::getCoptic($queryParams['date']);
            }
            $data = $data->where('date', 'like', "%$date%");
        }

        $filterData = InternalCircularResource::collection($data->paginate($perPage));

        return response()->json([
            'internal_circulars' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(InternalCircular $internal_circular){
        $internal_circular = new InternalCircularResource($internal_circular);
        return response()->json(['internal_circular'=>$internal_circular,'message'=>trans('api.internal circulars details')],200);
    }
    
    /* this method will stord data to DB Model*/
    public function store(InternalCircularRequest $request)
    {
        $date = \Carbon\Carbon::createFromFormat('Y-m-d',$request->date)->format('d/m/Y');

        $namozeg = Namazeg::where('form_number', 42)->first();
        $namozeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $request->school_id
        )->id;

        $internal_circular = InternalCircular::create([
            'school_id' => $request->school_id,
            'title' => $request->title,
            'namazeg_version_id' => $namozeg_version_id,
            'details' => $request->details,
            'date' => $date,
            'date_type' => 'coptic',
            'day' => $request->day,
        ]);

        if ($request->teachers) {
            foreach ($request->teachers as $teacher) {
                InternalCircularTeacher::create([
                    'internal_circular_id' => $internal_circular->id,
                    'school_employee_id' => $teacher,
                ]);
            }
        }
        HelperNotification::create_Circulars_notifications($request->school_id);

        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('InternalCircular', 'store', $school_id, '/circulars/internal-circulars/' . $internal_circular->id . '/details');

        return response()->json(['message' => trans('api.record stored successfully')], 200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(InternalCircularRequest $request,InternalCircular $internal_circular)
    {
        $date = \Carbon\Carbon::createFromFormat('Y-m-d',$request->date)->format('d/m/Y');

        $internal_circular->update([
            'school_id' => $request->school_id,
            'title' => $request->title,
            'details' => $request->details,
            'date' => $date,
            'day' => $request->day,
        ]);

        InternalCircularTeacher::where('internal_circular_id',$internal_circular->id)->forceDelete();
        if(isset($request->teachers)) {
            foreach ($request->teachers as $teacher) {
                InternalCircularTeacher::create([
                    'internal_circular_id' => $internal_circular->id,
                    'school_employee_id' => $teacher,
                ]);
            }
        }

        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('InternalCircular', 'update', $school_id, '/circulars/internal-circulars/' . $internal_circular->id . '/details');

        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(InternalCircular $internal_circular){
        $internal_circular->delete();
        InternalCircularTeacher::where('internal_circular_id',$internal_circular->id)->delete();
        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(InternalCircular $internal_circular){
        $internal_circular->forceDelete();
        InternalCircularTeacher::where('internal_circular_id',$internal_circular->id)->forceDelete();
        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id){
        InternalCircular::withTrashed()->findOrFail($id)->restore();
        InternalCircularTeacher::withTrashed()->where('internal_circular_id',$id)->restore();
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }
}