<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Assignments\GeneralAssignmentRequest;
use App\Http\Resources\ManagerDashboard\Assignments\DurationsAssigmentsResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Assignments\DurationAssignment;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\Assignments\GeneralAssignmentEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GeneralAssignmentController extends Controller
{
    use NamazegTrait;

    public function getDurations()
    {
        $durations = DurationsAssigmentsResource::collection(DurationAssignment::all());

        return response()->json(['durations' => $durations]);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(School $school,  GeneralAssignmentRequest $request)
    {

        $data = $request->validated();

        $employeeIds = $data['employees'];

        unset($data['employees']);

        $namozeg = Namazeg::firstWhere('form_number', 37);

        // Check if a NamazegVersion already exists for the school and namozeg_id
        $existing_version = NamazegVersion::where('namazeg_id', $namozeg->id)
            ->where('school_id', $school->id)
            ->first();

        if (!$existing_version) {
            // If no version exists, create a new one using the trait method
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school->id
            );
        } else {
            // Use the existing version
            $namozeg_version = $existing_version;
        }



        $date = Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');
        $date_type = $data['date_type'];

        if ($date_type === 'hijri') {
            $date = Helper::getCoptic($date);
            $date_type = 'coptic';
        }


        // $generalAssignment  = GeneralAssignment::updateOrCreate(
        //     [
        //         'namazeg_version_id' => $namozeg_version->id,
        //         'school_id' => $school->id,
        //     ],
        //     [
        //         'date' => $date,
        //         'date_type' => $date_type,
        //         'duration_id' => $data['duration_id'],
        //         'details' => $data['details'],
        //     ]
        // );
        $generalAssignment  = GeneralAssignment::create(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'date' => $date,
                'date_type' => $date_type,
                'duration_id' => $data['duration_id'],
                'details' => $data['details'],
            ]
        );

                // Delete existing GeneralAssignmentEmployee before re-inserting
        // GeneralAssignmentEmployee::where('general_assignment_id', $generalAssignment->id)->forceDelete();

        foreach ($employeeIds as $employeeId) {
            GeneralAssignmentEmployee::create([
                'general_assignment_id' => $generalAssignment->id,
                'employee_id' => $employeeId
            ]);
        }

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Soft Delete.
     */
    public function archive(School $school, GeneralAssignment $assignment, $employeeId)
    {

        DB::beginTransaction();

        try {

            GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)
                ->where('employee_id', $employeeId)
                ->delete();


            // Commit the transaction if everything is successful
            DB::commit();

            return response()->json(['message' => trans('api.record archived successfully')]);
        } catch (\Exception $e) {
            // Rollback the transaction if any error occurs
            DB::rollBack();

            return response()->json(['error' => trans('api.failed_to_archive_record')], 500);
        }
    }



    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(School $school, GeneralAssignment $assignment, $employeeId)
    {

        // $assignment->restore();

        GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)
            ->where('employee_id', $employeeId)
            ->restore();

        return response()->json(['message' => trans('api.record restored successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, GeneralAssignment $assignment, $employeeId)
    {

        GeneralAssignmentEmployee::where('general_assignment_id', $assignment->id)
            ->where('employee_id', $employeeId)
            ->forceDelete();


        // Check if there are any employees left for the assignment

        $assignmentEmployees = $assignment->generalAssignmentEmployees->count();
        // If no employees are left, delete the assignment
        if ($assignmentEmployees === 0) {
            $assignment->forceDelete();
        }

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
