<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Assignments\AssignmentCategoryResource;
use App\Http\Resources\ManagerDashboard\Assignments\CommitteeAssignmentResource;
use App\Http\Resources\ManagerDashboard\Assignments\GeneralAssignmentResource;
use App\Http\Resources\ManagerDashboard\Assignments\TeamAssignmentResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Assignments\AssignmentCategory as AssignmentsAssignmentCategory;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use Illuminate\Http\Request;

class AssignmentCategory extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(School $school, Request $request)
    {

        $data = AssignmentsAssignmentCategory::with(['jobs.assignments' => function ($query) use ($school) {
            $query->where('school_id', $school->id);
        }, 'jobs.assignments.assignmentEmployees.employee'])
            ->get();


        $committeesAssignments = CommitteeAssignmentResource::collection(
            Committee::whereNull('school_id') // Get default committees
                ->orWhere('school_id', $school->id) // Get committees for the specific school
                ->with([
                    'assignment' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure assignment is for the right school
                    },
                    'tasks' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure tasks are for the correct school
                    },
                    'meetings' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure meetings are for the right school
                    }
                ])
                ->get()
        );


        $teamsAssignments = TeamAssignmentResource::collection(
            Team::where('school_id', Null)
                ->orWhere('school_id', $school->id)
                ->with([
                    'assignment' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure assignment is for the right school
                    },
                    'tasks' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure tasks are for the correct school
                    },
                    'meetings' => function ($query) use ($school) {
                        $query->where('school_id', $school->id); // Ensure meetings are for the right school
                    }
                ])
                ->get()
        );

        $generalAssignments = GeneralAssignmentResource::collection(GeneralAssignment::where('school_id', $school->id)->with('generalAssignmentEmployees.employee')->get());

        $filterData = AssignmentCategoryResource::collection($data);

        // Inject the committees and teams assignments into the "اللجان و الفرق" category (id: 4)
        $filterData->transform(function ($category) use ($committeesAssignments, $teamsAssignments, $generalAssignments) {
            if ($category->id === 4) {
                $category->committeesAssignments = $committeesAssignments;
                $category->teamsAssignments = $teamsAssignments;
            }

            if ($category->id === 5) {
                $category->generalAssignments = $generalAssignments;
            }
            return $category;
        });

        return response()->json([
            'categories' => $filterData,

            'message' => trans('api.list of all available records'),
        ]);
    }

}
