<?php

namespace App\Http\Controllers\Api\AdminDashboard\Violation;

use App\Helpers\GradeViolationsHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Violation\ViolationTitleStoreNextRequest;
use Illuminate\Support\Facades\DB;

use App\Http\Requests\Violation\ViolationTitleStoreRequest;
use App\Http\Requests\Violation\ViolationTitleUpdateRequest;
use App\Models\ViolationTitle;
use App\Models\ViolationPunishment;
use App\Http\Resources\Violation\ViolationTitleStepResource;
use App\Models\BasicRelativePunishment;
use App\Models\Namazeg;
use App\Models\RelatedViolations;
use App\Traits\LogsActivity;

class ViolationTitleController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:violationTitles']);
    }

    /* this method will stord data to DB Model*/
    public function store(ViolationTitleStoreRequest $request)
    {
        $violationName_check = ViolationTitle::where('violation_grade_id', $request->violation_grade_id)
            ->where('name', $request->name_id)->first();
        if ($violationName_check) {
            return response()->json(['message' => 'الاجراء تم استخدامه بالفعل'], 422);
        }

        $title = ViolationTitle::create(['name' => $request->name_id, 'violation_grade_id' => $request->violation_grade_id]);
        foreach ($request->punishments as $punishment) {
            $namozeg = Namazeg::findOrFail($punishment['id']);
            $violation_punishment = ViolationPunishment::create([
                'violation_title_id' => $title->id,
                'violation_punishment_id' => $punishment['id'],
                'value' => $namozeg->form_number == 149 ? $punishment['degree'] : null
            ]);
            if (isset($punishment['related_punishment_ids'])) {
                foreach ($punishment['related_punishment_ids'] as $basic_related_punishment_id) {
                    BasicRelativePunishment::create([
                        'relation_violation_punishment_id' => $violation_punishment->id,
                        'violation_punishment_id' => $basic_related_punishment_id,
                    ]);
                }
            }
        }
        $this->AdminlogActivity('ViolationTitle', 'store', '/violations/grade/' . $request->violation_grade_id);


        return response()->json(['violation' => $title, 'message' => trans('api.record stored successflly')]);
    }


    public function next_step_data(ViolationTitle $violation_title,)
    {

        $violations = ViolationTitle::with('violation_name', 'punishments')
            ->where('name', '<', (int) $violation_title->name)
            ->where('violation_grade_id', $violation_title->violation_grade_id)->get();
        $data_resorce = ViolationTitleStepResource::collection($violations);
        return response()->json(['violations' => $data_resorce]);
    }

    public function store_next_step(ViolationTitle $violation_title, ViolationTitleStoreNextRequest $request)
    {
        $data = json_decode($request->getContent());
        RelatedViolations::where('relation_violation_titles_id', $violation_title->id)->delete();
        foreach ($data as $object) {
            // اجراء وفيه نماذج اختياريه 
            foreach ($object->violation_punishment_ids as $violation_punishment_id) {
                RelatedViolations::create([
                    "relation_violation_titles_id" => $violation_title->id,
                    "violation_titles_id" => $object->id,
                    "violation_punishment_id" => $violation_punishment_id,
                    'custom_name' => $object->custom_name,
                    "addition_related" => "related"
                ]);
            }

            // اجراء وفيه نماذج اجبارية مع الاجراء ده
            if (!empty($object->other_punishment_ids)) {
                foreach ($object->other_punishment_ids as $other_punishment_id) {
                    RelatedViolations::create([
                        "relation_violation_titles_id" => $violation_title->id,
                        "violation_titles_id" => $object->id,
                        "violation_punishment_id" => $other_punishment_id,
                        'custom_name' => $object->custom_name,
                        "addition_related" => "addition"
                    ]);
                }
            }
        }
        $violation_title->update(['has_related' => true]);
        return response()->json(['message' => trans('api.record stored successflly')]);
    }


    public function get_related_titles(ViolationTitle $violation_title)
    {
        $first_violation_title_data = GradeViolationsHelper::get_admin_violation_title_data($violation_title->id);

        return response()->json(['violations' => $first_violation_title_data]);
    }

    public function update(ViolationTitleUpdateRequest $request, $id)
    {
        // Find the violation title or fail
        $title = ViolationTitle::findOrFail($id);

        DB::transaction(function () use ($request, $title) {
            // Update the title name
            $title->update(['name' => $request->name_id]);

            // Update or create punishment associations
            if (!empty($request->punishments)) {
                $violation_punishemnts = ViolationPunishment::where('violation_title_id', $title->id)->get();
                $violation_punishemnt_ids = $violation_punishemnts->pluck('id')->toArray();
                BasicRelativePunishment::where('relation_violation_punishment_id', $violation_punishemnt_ids)->delete();
                ViolationPunishment::where('violation_title_id', $title->id)->delete();

                foreach ($request->punishments as $punishment_id) {
                    $namozeg = Namazeg::findOrFail($punishment_id['id']);
                    $violation_punishment = ViolationPunishment::Create(
                        [
                            'violation_title_id' => $title->id,
                            'violation_punishment_id' =>  $punishment_id['id'],
                            'value' => $namozeg->form_number == 149 ? $punishment_id['degree'] : null
                        ]
                    );
                    if (isset($punishment_id['related_punishment_ids'])) {
                        foreach ($punishment_id['related_punishment_ids'] as $basic_related_punishment_id) {
                            BasicRelativePunishment::create([
                                'relation_violation_punishment_id' => $violation_punishment->id,
                                'violation_punishment_id' => $basic_related_punishment_id,
                            ]);
                        }
                    }
                }
            }
        });
        $this->AdminlogActivity('ViolationTitle', 'update', '/violations/grade/' . $title->violation_grade_id);
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        ViolationTitle::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('ViolationTitle', 'delete');

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        ViolationTitle::findOrFail($id)->delete();
        $this->AdminlogActivity('ViolationTitle', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        ViolationTitle::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('ViolationTitle', 'restore');
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
