<?php
namespace App\Http\Controllers\Api\AdminDashboard\Video;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Video\VideoStoreRequest;
use App\Http\Requests\Video\VideoUpdateRequest;
use App\Models\Video;
use App\Http\Resources\Video\VideoResource;
use App\Traits\LogsActivity;

class VideoController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:videos']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = Video::with('category');

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\Video', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = VideoResource::collection($data->paginate($perPage));

        return response()->json([
            'videos' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id){
        $video = Video::findOrFail($id);
        $video = new VideoResource($video);
        return response()->json(['video'=>$video,'message'=>trans('api.slider details') ]);
    }

    /* this method will stord data to DB Model*/
    public function store(VideoStoreRequest $request){
        $video = Video::create($request->all());
        $this->AdminlogActivity('Video', 'store');
        $this->AdminlogActivity('Video', 'store', '/videos/' . $video->id);

        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(VideoUpdateRequest $request,$id){
        Video::findOrFail($id)->update($request->all());
        $this->AdminlogActivity('Video', 'update', '/videos/' . $id);
        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id){
        Video::findOrFail($id)->delete();
        $this->AdminlogActivity('Video', 'archive');

        return response()->json(['message'=>trans('api.record archived successflly') ]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        Video::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('Video', 'delete');

        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id){
        Video::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('Video', 'restore');

        return response()->json(['message'=>trans('api.record restored successflly') ]);
    }
    
}