<?php

namespace App\Http\Controllers\Api\AdminDashboard\Marketing;

use App\Exports\StudentExport;
use App\Http\Controllers\Controller;
use App\Http\Resources\School\ClassNameResource;
use App\Http\Resources\School\SchoolStudentResource;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use JWTAuth;

use Illuminate\Http\Request;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\Student;

use App\Helpers\Helper;
use Maatwebsite\Excel\Facades\Excel;

class MarketingController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api',,'permission:marketing']);
    }

    /** fundtion return all schools students */
    public function getAll(Request $request){

        // Start with the base query
        $data = Student::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\Student', $queryParams);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($data->paginate($perPage));

        return response()->json(['students' => $filterData, 'message' => trans('api.list of all available records')]);
    }

    /** fundtion return all schools students */
    public function filterStudentsData(Request $request){
        $data = Student::query();

        /** filter by school city ids */
        if($request->city_ids){
            $city_ids = explode(",", $request->city_ids);
            $schoolIds = School::whereIn('city_id',$city_ids)->pluck('id')->toArray();
            $filterData = $data->whereIn('school_id',$schoolIds);
        }
        /** filter by school  */
        if($request->school_name){
            $school = School::where('name','like',"%$request->school_name%")->first();
            $filterData = $data->where('school_id',$school->id);
        }

        /** filter by grade  */
        if($request->grade_id){
            $schoolIds = School::where('grade_id',$request->grade_id)->pluck('id')->toArray();
            $filterData = $data->whereIn('school_id',$schoolIds);
        }

        /** filter by class name  */
        if($request->class_name_id){
            $schoolClassIds = SchoolClass::where('class_name_id',$request->class_name_id)->pluck('id')->toArray();
            $filterData = $data->whereIn('class_id',$schoolClassIds);
        }

        /** filter by nationality */
        if($request->nationality){
            $filterData = $data->where('nationality', 'like', "%$request->nationality%");
        }

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($filterData->paginate($perPage));

        return response()->json(['students' => $filterData, 'message' => trans('api.list of all available records')]);
    }

    public function exportStudents(Request $request){
        $start_date = $request->input('start_date');
        $end_date = $request->input('end_date');
        if (isset($request['date_type']) && isset($request['start_date'])  && isset($request['end_date'])) {
            $start_date = $request['start_date'];
            $end_date = $request['end_date'];

            if ($request['date_type'] == "hijri") {
                $start_date = Helper::getCoptic($request['start_date']);
                $end_date = Helper::getCoptic($request['end_date']);
            }
        }
        return Excel::download(new StudentExport($start_date, $end_date), 'marketing_students.xlsx', \Maatwebsite\Excel\Excel::XLSX, [
            'Content-Disposition' => 'attachment; filename="marketing_students_' . time() . '.xlsx"',
        ]);
    }

    public function SchoolsAutoComplete(Request $request){
        return Helper::autocomplete('App\Models\AdminDashboard\School\School','name',$request->school_name);
    }

    /* function return all system class name*/
    public function getClassNames(){
        $classNames = ClassNameResource::collection(ClassName::distinct()->get());
        return response()->json(['classNames' => $classNames, 'message' => trans('api.list of all available records')]);
    }


}
