<?php

namespace App\Http\Controllers\Api\AdminDashboard\BankAccount;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AdminDashboard\BankAccount\BankAccount;
use App\Helpers\Helper;
use App\Http\Requests\AdminDashboard\BankAccount\StoreAccountRequest;
use App\Http\Requests\AdminDashboard\BankAccount\UpdateAccountRequest;
use App\Http\Resources\AdminDashboard\BankAccount\BankAccountResource;
use Illuminate\Auth\Events\Validated;

class BankAccountController extends Controller
{
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:bank-accounts']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        // Start with the base query
        $data = BankAccount::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\BankAccount\BankAccount', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = BankAccountResource::collection($data->paginate($perPage));


        return response()->json([
            'bankAccounts' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAccountRequest $request)
    {
       $data = $request->validated();

       $data = request()->except('bank_logo');

        $bankAccount =  BankAccount::create($data);

        if (request()->hasFile('bank_logo')) {
            $fileName =  Helper::uploadImage('BankAccounts', request()->file('bank_logo'));
            $bankAccount->bank_logo = $fileName;
            $bankAccount->save();
        }

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function show(BankAccount $account)
    {
        $account =  new BankAccountResource($account);
        return  response()->json(['account' => $account], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAccountRequest $request, BankAccount $account)
    {
        $data = $request->validated();

        unset($data['bank_logo']);

        $account->update($data);


        if (request()->hasFile('bank_logo')) {
            $fileName = Helper::uploadImage('BankAccounts', request()->file('bank_logo'));

            // Delete the existing logo, if it exists
            if ($account->bank_logo) {
                Helper::removeImage(url('public/uploads/BankAccounts/' . $account->bank_logo));
            }
            $account->bank_logo = $fileName;
            $account->save();
        }



        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }


    public function archive( BankAccount $account)
    {
        $account->delete();

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( BankAccount $account)
    {
        $account->forceDelete();
        if ($account->bank_logo) {
            Helper::removeImage(url('public/uploads/BankAccounts/' . $account->bank_logo));
        }

        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }

}
